/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser;

import com.aspectran.core.context.rule.appender.AbstractRuleAppender;
import com.aspectran.core.context.rule.appender.FileRuleAppender;
import com.aspectran.core.context.rule.appender.ResourceRuleAppender;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.ActivityContextParser;
import com.aspectran.core.context.rule.type.AppendableFileFormatType;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public abstract class AbstractActivityContextParser
implements ActivityContextParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ActivityRuleAssistant assistant;
    private String encoding;
    private boolean useXmlToApon;
    private boolean debugMode;

    public AbstractActivityContextParser(ActivityRuleAssistant assistant) {
        this.assistant = assistant;
    }

    @Override
    public ActivityRuleAssistant getContextRuleAssistant() {
        return this.assistant;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected boolean isUseXmlToApon() {
        return this.useXmlToApon;
    }

    @Override
    public void setUseXmlToApon(boolean useXmlToApon) {
        this.useXmlToApon = useXmlToApon;
    }

    protected boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    protected RuleAppender resolveAppender(@NonNull String classpathOrFilePath) {
        AbstractRuleAppender appender;
        if (classpathOrFilePath.startsWith("classpath:")) {
            String resource = classpathOrFilePath.substring("classpath:".length());
            appender = new ResourceRuleAppender(resource, this.assistant.getClassLoader());
        } else if (classpathOrFilePath.startsWith("file:")) {
            String filePath = classpathOrFilePath.substring("file:".length());
            appender = new FileRuleAppender(filePath);
        } else {
            appender = new FileRuleAppender(this.assistant.getBasePath(), classpathOrFilePath);
        }
        if (classpathOrFilePath.toLowerCase().endsWith(".apon")) {
            appender.setAppendableFileFormatType(AppendableFileFormatType.APON);
        } else {
            appender.setAppendableFileFormatType(AppendableFileFormatType.XML);
        }
        return appender;
    }
}

