/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser;

import com.aspectran.core.context.rule.appender.HybridRuleAppendHandler;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.converter.ParametersToRules;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.parser.AbstractActivityContextParser;
import com.aspectran.core.context.rule.parser.ActivityContextParserException;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class HybridActivityContextParser
extends AbstractActivityContextParser {
    public HybridActivityContextParser(ActivityRuleAssistant assistant) {
        super(assistant);
    }

    @Override
    public ActivityRuleAssistant parse(String[] contextRules) throws ActivityContextParserException {
        try {
            if (contextRules == null) {
                throw new IllegalArgumentException("contextRules must not be null");
            }
            RuleAppendHandler appendHandler = this.createRuleAppendHandler();
            for (String ruleFile : contextRules) {
                appendHandler.handle(this.resolveAppender(ruleFile));
            }
            return this.getContextRuleAssistant();
        }
        catch (Exception e) {
            throw new ActivityContextParserException("Failed to parse configurations [" + StringUtils.joinCommaDelimitedList(contextRules) + "]", e);
        }
    }

    @Override
    public ActivityRuleAssistant parse(AspectranParameters aspectranParameters) throws ActivityContextParserException {
        try {
            if (aspectranParameters == null) {
                throw new IllegalArgumentException("aspectranParameters must not be null");
            }
            RuleAppendHandler appendHandler = this.createRuleAppendHandler();
            ParametersToRules ruleConverter = new ParametersToRules(this.getContextRuleAssistant());
            ruleConverter.toRules(aspectranParameters);
            appendHandler.handle(null);
            return this.getContextRuleAssistant();
        }
        catch (Exception e) {
            throw new ActivityContextParserException("Failed to parse configuration with given AspectranParameters", e);
        }
    }

    @NonNull
    private RuleAppendHandler createRuleAppendHandler() {
        HybridRuleAppendHandler appendHandler = new HybridRuleAppendHandler(this.getContextRuleAssistant(), this.getEncoding());
        appendHandler.setUseAponToLoadXml(this.isUseXmlToApon());
        appendHandler.setDebugMode(this.isDebugMode());
        this.getContextRuleAssistant().setRuleAppendHandler(appendHandler);
        return appendHandler;
    }
}

