/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.nodelet.NodeletParser;
import com.aspectran.utils.nodelet.SubnodeParser;

class AspectNodeParser
implements SubnodeParser {
    AspectNodeParser() {
    }

    @Override
    public void parse(@NonNull String xpath, @NonNull NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/aspect");
        parser.addNodelet(attrs -> {
            String id = StringUtils.emptyToNull((String)attrs.get("id"));
            String order = StringUtils.emptyToNull((String)attrs.get("order"));
            Boolean isolated = BooleanUtils.toNullableBooleanObject((String)attrs.get("isolated"));
            Boolean disabled = BooleanUtils.toNullableBooleanObject((String)attrs.get("disabled"));
            AspectRule aspectRule = AspectRule.newInstance(id, order, isolated, disabled);
            parser.pushObject(aspectRule);
        });
        parser.addEndNodelet(text -> {
            AspectRule aspectRule = (AspectRule)parser.popObject();
            assistant.addAspectRule(aspectRule);
        });
        parser.setXpath(xpath + "/aspect/description");
        parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            parser.pushObject(descriptionRule);
        });
        parser.addEndNodelet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)parser.popObject();
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            descriptionRule.setContent(text);
            descriptionRule = assistant.profiling(descriptionRule, aspectRule.getDescriptionRule());
            aspectRule.setDescriptionRule(descriptionRule);
        });
        parser.setXpath(xpath + "/aspect/joinpoint");
        parser.addNodelet(attrs -> {
            String target = StringUtils.emptyToNull((String)attrs.get("target"));
            parser.pushObject(target);
        });
        parser.addEndNodelet(text -> {
            String target = (String)parser.popObject();
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            AspectRule.updateJoinpoint(aspectRule, target, text);
        });
        parser.setXpath(xpath + "/aspect/settings");
        parser.addNodelet(attrs -> {
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            SettingsAdviceRule sar = SettingsAdviceRule.newInstance(aspectRule);
            parser.pushObject(sar);
        });
        parser.addEndNodelet(text -> {
            SettingsAdviceRule sar = (SettingsAdviceRule)parser.popObject();
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            aspectRule.setSettingsAdviceRule(sar);
        });
        parser.setXpath(xpath + "/aspect/settings/setting");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            parser.pushObject(value);
            parser.pushObject(name);
        });
        parser.addEndNodelet(text -> {
            String name = (String)parser.popObject();
            String value = (String)parser.popObject();
            SettingsAdviceRule sar = (SettingsAdviceRule)parser.peekObject();
            if (value != null) {
                sar.putSetting(name, value);
            } else if (text != null) {
                sar.putSetting(name, text);
            }
        });
        parser.setXpath(xpath + "/aspect/advice");
        parser.addNodelet(attrs -> {
            String beanIdOrClass = StringUtils.emptyToNull((String)attrs.get("bean"));
            if (beanIdOrClass != null) {
                AspectRule aspectRule = (AspectRule)parser.peekObject();
                aspectRule.setAdviceBeanId(beanIdOrClass);
                assistant.resolveAdviceBeanClass(aspectRule);
            }
        });
        nodeParser.parseAspectAdviceInnerNode();
        parser.setXpath(xpath + "/aspect/exception");
        parser.addNodelet(attrs -> {
            ExceptionRule exceptionRule = new ExceptionRule();
            parser.pushObject(exceptionRule);
        });
        nodeParser.parseExceptionInnerNode();
        parser.addEndNodelet(text -> {
            ExceptionRule exceptionRule = (ExceptionRule)parser.popObject();
            AspectRule aspectRule = (AspectRule)parser.peekObject();
            aspectRule.setExceptionRule(exceptionRule);
        });
    }
}

