/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.ActionNodeParser;
import com.aspectran.core.context.rule.parser.xml.AspectAdviceInnerNodeParser;
import com.aspectran.core.context.rule.parser.xml.AspectNodeParser;
import com.aspectran.core.context.rule.parser.xml.AspectranDtdResolver;
import com.aspectran.core.context.rule.parser.xml.BeanNodeParser;
import com.aspectran.core.context.rule.parser.xml.ChooseNodeParser;
import com.aspectran.core.context.rule.parser.xml.EnvironmentNodeParser;
import com.aspectran.core.context.rule.parser.xml.ExceptionInnerNodeParser;
import com.aspectran.core.context.rule.parser.xml.InnerBeanNodeParser;
import com.aspectran.core.context.rule.parser.xml.ItemNodeParser;
import com.aspectran.core.context.rule.parser.xml.ResponseInnerNodeParser;
import com.aspectran.core.context.rule.parser.xml.ScheduleNodeParser;
import com.aspectran.core.context.rule.parser.xml.TemplateNodeParser;
import com.aspectran.core.context.rule.parser.xml.TransletNodeParser;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.nodelet.NodeletParser;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.InputSource;

public class AspectranNodeParser {
    private static final Logger logger = LoggerFactory.getLogger(AspectranNodeParser.class);
    private final ActivityRuleAssistant assistant;
    private final ActionNodeParser actionNodeParser;
    private final AspectAdviceInnerNodeParser aspectAdviceInnerNodeParser;
    private final AspectNodeParser aspectNodeParser;
    private final BeanNodeParser beanNodeParser;
    private final ChooseNodeParser chooseNodeParser;
    private final EnvironmentNodeParser environmentNodeParser;
    private final ExceptionInnerNodeParser exceptionInnerNodeParser;
    private final ItemNodeParser[] itemNodeParsers;
    private final InnerBeanNodeParser[] innerBeanNodeParsers;
    private final ResponseInnerNodeParser responseInnerNodeParser;
    private final ScheduleNodeParser scheduleNodeParser;
    private final TemplateNodeParser templateNodeParser;
    private final TransletNodeParser transletNodeParser;
    private final NodeletParser parser;

    public AspectranNodeParser(ActivityRuleAssistant assistant) {
        this(assistant, true, true);
    }

    public AspectranNodeParser(ActivityRuleAssistant assistant, boolean validating, boolean trackingLocation) {
        this.assistant = assistant;
        this.actionNodeParser = new ActionNodeParser();
        this.aspectAdviceInnerNodeParser = new AspectAdviceInnerNodeParser();
        this.aspectNodeParser = new AspectNodeParser();
        this.beanNodeParser = new BeanNodeParser();
        this.chooseNodeParser = new ChooseNodeParser();
        this.environmentNodeParser = new EnvironmentNodeParser();
        this.exceptionInnerNodeParser = new ExceptionInnerNodeParser();
        this.responseInnerNodeParser = new ResponseInnerNodeParser();
        this.scheduleNodeParser = new ScheduleNodeParser();
        this.templateNodeParser = new TemplateNodeParser();
        this.transletNodeParser = new TransletNodeParser();
        this.itemNodeParsers = new ItemNodeParser[]{new ItemNodeParser(0), new ItemNodeParser(1), new ItemNodeParser(2), new ItemNodeParser(3)};
        this.innerBeanNodeParsers = new InnerBeanNodeParser[]{null, new InnerBeanNodeParser(1), new InnerBeanNodeParser(2), new InnerBeanNodeParser(3)};
        this.parser = new NodeletParser(this);
        this.parser.setValidating(validating);
        this.parser.setEntityResolver(new AspectranDtdResolver(validating));
        if (trackingLocation) {
            this.parser.trackingLocation();
        }
        this.parseDescriptionNode();
        this.parseSettingsNode();
        this.parseTypeAliasNode();
        this.parseEnvironmentNode();
        this.parseAspectNode();
        this.parseBeanNode();
        this.parseScheduleNode();
        this.parseTemplateNode();
        this.parseTransletNode();
        this.parseAppendNode();
    }

    public ActivityRuleAssistant getAssistant() {
        return this.assistant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(RuleAppender ruleAppender) throws Exception {
        InputStream inputStream = null;
        try {
            ruleAppender.setNodeTracker(this.parser.getNodeTracker());
            inputStream = ruleAppender.getInputStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(ruleAppender.getQualifiedName());
            this.parser.parse(inputSource);
        }
        catch (Exception e) {
            Throwable cause = ExceptionUtils.getRootCause(e);
            if (cause instanceof IllegalRuleException) {
                this.parsingFailed(cause.getMessage(), cause);
            } else {
                this.parsingFailed("Error parsing aspectran configuration", e);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void parsingFailed(String message, Throwable cause) throws Exception {
        String detail = this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getNodeTracker().getName() != null ? message + ": " + String.valueOf(this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getNodeTracker()) + " on " + this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getQualifiedName() : message + ": " + this.assistant.getRuleAppendHandler().getCurrentRuleAppender().getQualifiedName();
        logger.error(detail);
        throw new Exception(detail, cause);
    }

    private void parseDescriptionNode() {
        this.parser.setXpath("/aspectran/description");
        this.parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            this.parser.pushObject(descriptionRule);
        });
        this.parser.addEndNodelet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)this.parser.popObject();
            descriptionRule.setContent(text);
            descriptionRule = this.assistant.profiling(descriptionRule, this.assistant.getAssistantLocal().getDescriptionRule());
            this.assistant.getAssistantLocal().setDescriptionRule(descriptionRule);
        });
    }

    private void parseSettingsNode() {
        this.parser.setXpath("/aspectran/settings");
        this.parser.addEndNodelet(text -> this.assistant.applySettings());
        this.parser.setXpath("/aspectran/settings/setting");
        this.parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            this.parser.pushObject(value);
            this.parser.pushObject(name);
        });
        this.parser.addEndNodelet(text -> {
            String name = (String)this.parser.popObject();
            String value = (String)this.parser.popObject();
            if (value != null) {
                this.assistant.putSetting(name, value);
            } else if (text != null) {
                this.assistant.putSetting(name, text);
            }
        });
    }

    private void parseTypeAliasNode() {
        this.parser.setXpath("/aspectran/typeAliases/typeAlias");
        this.parser.addNodelet(attrs -> {
            String alias = (String)attrs.get("alias");
            String type = (String)attrs.get("type");
            this.parser.pushObject(type);
            this.parser.pushObject(alias);
        });
        this.parser.addEndNodelet(text -> {
            String alias = (String)this.parser.popObject();
            String type = (String)this.parser.popObject();
            if (type != null) {
                this.assistant.addTypeAlias(alias, type);
            } else if (text != null) {
                this.assistant.addTypeAlias(alias, text);
            }
        });
    }

    private void parseEnvironmentNode() {
        this.parser.addNodelet("/aspectran", this.environmentNodeParser);
    }

    private void parseAspectNode() {
        this.parser.addNodelet("/aspectran", this.aspectNodeParser);
    }

    private void parseBeanNode() {
        this.parser.addNodelet("/aspectran", this.beanNodeParser);
    }

    private void parseScheduleNode() {
        this.parser.addNodelet("/aspectran", this.scheduleNodeParser);
    }

    private void parseTemplateNode() {
        this.parser.addNodelet("/aspectran", this.templateNodeParser);
    }

    private void parseTransletNode() {
        this.parser.addNodelet("/aspectran", this.transletNodeParser);
    }

    private void parseAppendNode() {
        this.parser.setXpath("/aspectran/append");
        this.parser.addNodelet(attrs -> {
            String file = (String)attrs.get("file");
            String resource = (String)attrs.get("resource");
            String url = (String)attrs.get("url");
            String format = (String)attrs.get("format");
            String profile = (String)attrs.get("profile");
            RuleAppendHandler appendHandler = this.assistant.getRuleAppendHandler();
            if (appendHandler != null) {
                AppendRule appendRule = AppendRule.newInstance(file, resource, url, format, profile);
                appendHandler.pending(appendRule);
            }
        });
    }

    void parseActionNode() {
        this.parser.addNodelet(this.actionNodeParser);
    }

    void parseNestedActionNode() {
        String xpath = this.parser.getXpath();
        this.parser.addNodelet(this.actionNodeParser);
        this.parser.addNodelet(this.chooseNodeParser);
        this.parser.setXpath(xpath + "/choose/when");
        this.parser.addNodelet(this.chooseNodeParser);
        this.parser.setXpath(xpath + "/choose/otherwise");
        this.parser.addNodelet(this.chooseNodeParser);
        this.parser.setXpath(xpath + "/choose/when/choose/when/choose");
        this.parser.addNodelet(attrs -> this.chooseElementsNestingLimitExceeded());
        this.parser.setXpath(xpath + "/choose/when/choose/otherwise/choose");
        this.parser.addNodelet(attrs -> this.chooseElementsNestingLimitExceeded());
        this.parser.setXpath(xpath + "/choose/otherwise/choose/when/choose");
        this.parser.addNodelet(attrs -> this.chooseElementsNestingLimitExceeded());
        this.parser.setXpath(xpath + "/choose/otherwise/choose/otherwise/choose");
        this.parser.addNodelet(attrs -> this.chooseElementsNestingLimitExceeded());
        this.parser.setXpath(xpath);
    }

    void parseAspectAdviceInnerNode() {
        this.parser.addNodelet(this.aspectAdviceInnerNodeParser);
    }

    void parseExceptionInnerNode() {
        this.parser.addNodelet(this.exceptionInnerNodeParser);
    }

    void parseResponseInnerNode() {
        this.parser.addNodelet(this.responseInnerNodeParser);
    }

    void parseItemNode() {
        this.parseItemNode(0);
    }

    void parseItemNode(int depth) {
        this.parser.addNodelet(this.itemNodeParsers[depth]);
    }

    void parseInnerBeanNode(int depth) {
        if (depth < this.innerBeanNodeParsers.length - 1) {
            this.parser.addNodelet(this.innerBeanNodeParsers[depth + 1]);
        }
    }

    int getMaxInnerBeans() {
        return this.innerBeanNodeParsers.length - 1;
    }

    private void chooseElementsNestingLimitExceeded() throws IllegalRuleException {
        throw new IllegalRuleException("The <choose> element can be nested up to 2 times");
    }
}

