/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.nodelet.NodeletParser;
import com.aspectran.utils.nodelet.SubnodeParser;

class ExceptionInnerNodeParser
implements SubnodeParser {
    ExceptionInnerNodeParser() {
    }

    @Override
    public void parse(@NonNull String xpath, @NonNull NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/description");
        parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            parser.pushObject(descriptionRule);
        });
        parser.addEndNodelet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)parser.popObject();
            ExceptionRule exceptionRule = (ExceptionRule)parser.peekObject();
            descriptionRule.setContent(text);
            descriptionRule = assistant.profiling(descriptionRule, exceptionRule.getDescriptionRule());
            exceptionRule.setDescriptionRule(descriptionRule);
        });
        parser.setXpath(xpath + "/thrown");
        parser.addNodelet(attrs -> {
            String exceptionType = (String)attrs.get("type");
            ExceptionThrownRule etr = new ExceptionThrownRule();
            if (exceptionType != null) {
                String[] exceptionTypes = StringUtils.splitCommaDelimitedString(exceptionType);
                etr.setExceptionTypes(exceptionTypes);
            }
            parser.pushObject(etr);
        });
        nodeParser.parseActionNode();
        nodeParser.parseResponseInnerNode();
        parser.addEndNodelet(text -> {
            ExceptionThrownRule etr = (ExceptionThrownRule)parser.popObject();
            ExceptionRule exceptionRule = (ExceptionRule)parser.peekObject();
            exceptionRule.putExceptionThrownRule(etr);
        });
    }
}

