/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.token.TokenParser;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.nodelet.NodeletParser;
import com.aspectran.utils.nodelet.SubnodeParser;

class ItemNodeParser
implements SubnodeParser {
    private final int depth;

    ItemNodeParser(int depth) {
        this.depth = depth;
    }

    @Override
    public void parse(@NonNull String xpath, @NonNull NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/item");
        parser.addNodelet(attrs -> {
            String type = (String)attrs.get("type");
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            String valueType = (String)attrs.get("valueType");
            Boolean tokenize = BooleanUtils.toNullableBooleanObject((String)attrs.get("tokenize"));
            Boolean mandatory = BooleanUtils.toNullableBooleanObject((String)attrs.get("mandatory"));
            Boolean secret = BooleanUtils.toNullableBooleanObject((String)attrs.get("secret"));
            ItemRule itemRule = ItemRule.newInstance(type, name, valueType, tokenize, mandatory, secret);
            if (value != null && itemRule.getType() == ItemType.SINGLE) {
                itemRule.setValue(value);
            }
            parser.pushObject(itemRule);
        });
        if (this.depth < nodeParser.getMaxInnerBeans()) {
            nodeParser.parseInnerBeanNode(this.depth);
        } else {
            parser.setXpath(xpath + "/item/bean");
            parser.addNodelet(attrs -> this.nestLimitExceeded(nodeParser.getMaxInnerBeans()));
            parser.setXpath(xpath + "/item");
        }
        parser.addEndNodelet(text -> {
            ItemRule itemRule = (ItemRule)parser.popObject();
            ItemRuleMap itemRuleMap = (ItemRuleMap)parser.peekObject();
            if (itemRule.getType() == ItemType.SINGLE && StringUtils.hasText(text)) {
                itemRule.setValue(text);
            }
            assistant.resolveBeanClass(itemRule);
            itemRuleMap.putItemRule(itemRule);
        });
        parser.setXpath(xpath + "/item/value");
        parser.addEndNodelet(text -> {
            if (StringUtils.hasText(text)) {
                ItemRule itemRule = (ItemRule)parser.peekObject();
                if (itemRule.getValueType() == ItemValueType.BEAN) {
                    throw new IllegalRuleException("<bean> and <value> elements cannot exist together within an <item> element");
                }
                if (itemRule.isListableType()) {
                    itemRule.addValue(TokenParser.makeTokens(text, itemRule.isTokenize()));
                } else if (itemRule.getType() == ItemType.SINGLE) {
                    itemRule.setValue(TokenParser.makeTokens(text, itemRule.isTokenize()));
                }
            }
        });
        parser.setXpath(xpath + "/item/entry");
        parser.addNodelet(attrs -> {
            String name = (String)attrs.get("name");
            String value = (String)attrs.get("value");
            String tokenize = (String)attrs.get("tokenize");
            parser.pushObject(tokenize);
            parser.pushObject(value);
            parser.pushObject(name);
        });
        if (this.depth < nodeParser.getMaxInnerBeans()) {
            nodeParser.parseInnerBeanNode(this.depth);
        } else {
            parser.setXpath(xpath + "/item/entry/bean");
            parser.addNodelet(attrs -> this.nestLimitExceeded(nodeParser.getMaxInnerBeans()));
            parser.setXpath(xpath + "/item/entry");
        }
        parser.addEndNodelet(text -> {
            String name = (String)parser.popObject();
            String value = (String)parser.popObject();
            String tokenize = (String)parser.popObject();
            ItemRule itemRule = (ItemRule)parser.peekObject();
            if (itemRule.isMappableType() && itemRule.getValueType() != ItemValueType.BEAN) {
                boolean isTokenize = BooleanUtils.toBoolean(BooleanUtils.toNullableBooleanObject(tokenize), itemRule.isTokenize());
                Token[] tokens = null;
                if (value != null) {
                    tokens = TokenParser.makeTokens(value, isTokenize);
                } else if (StringUtils.hasText(text)) {
                    tokens = TokenParser.makeTokens(text, isTokenize);
                }
                itemRule.putValue(name, tokens);
            }
        });
    }

    private void nestLimitExceeded(int maxInnerBeans) throws IllegalRuleException {
        StringBuilder sb = new StringBuilder("Inner beans can be nested up to ");
        if (maxInnerBeans > 1) {
            sb.append(maxInnerBeans);
            sb.append(" times");
        } else {
            sb.append("at most once");
        }
        throw new IllegalRuleException(sb.toString());
    }
}

