/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.nodelet.NodeletParser;
import com.aspectran.utils.nodelet.SubnodeParser;

class ScheduleNodeParser
implements SubnodeParser {
    ScheduleNodeParser() {
    }

    @Override
    public void parse(@NonNull String xpath, @NonNull NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/schedule");
        parser.addNodelet(attrs -> {
            String id = StringUtils.emptyToNull((String)attrs.get("id"));
            ScheduleRule scheduleRule = ScheduleRule.newInstance(id);
            parser.pushObject(scheduleRule);
        });
        parser.addEndNodelet(text -> {
            ScheduleRule scheduleRule = (ScheduleRule)parser.popObject();
            assistant.addScheduleRule(scheduleRule);
        });
        parser.setXpath(xpath + "/schedule/description");
        parser.addNodelet(attrs -> {
            String profile = (String)attrs.get("profile");
            String style = (String)attrs.get("style");
            DescriptionRule descriptionRule = DescriptionRule.newInstance(profile, style);
            parser.pushObject(descriptionRule);
        });
        parser.addEndNodelet(text -> {
            DescriptionRule descriptionRule = (DescriptionRule)parser.popObject();
            ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
            descriptionRule.setContent(text);
            descriptionRule = assistant.profiling(descriptionRule, scheduleRule.getDescriptionRule());
            scheduleRule.setDescriptionRule(descriptionRule);
        });
        parser.setXpath(xpath + "/schedule/scheduler");
        parser.addNodelet(attrs -> {
            String beanIdOrClass = StringUtils.emptyToNull((String)attrs.get("bean"));
            if (beanIdOrClass != null) {
                ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
                scheduleRule.setSchedulerBeanId(beanIdOrClass);
            }
        });
        parser.setXpath(xpath + "/schedule/scheduler/trigger");
        parser.addNodelet(attrs -> {
            String type = StringUtils.emptyToNull((String)attrs.get("type"));
            parser.pushObject(type);
        });
        parser.addEndNodelet(text -> {
            String type = (String)parser.popObject();
            ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
            ScheduleRule.updateTrigger(scheduleRule, type, text);
        });
        parser.setXpath(xpath + "/schedule/job");
        parser.addNodelet(attrs -> {
            String transletName = StringUtils.emptyToNull((String)attrs.get("translet"));
            Boolean disabled = BooleanUtils.toNullableBooleanObject((String)attrs.get("disabled"));
            ScheduleRule scheduleRule = (ScheduleRule)parser.peekObject();
            ScheduledJobRule scheduledJobRule = ScheduledJobRule.newInstance(scheduleRule, transletName, disabled);
            scheduleRule.addScheduledJobRule(scheduledJobRule);
        });
    }
}

