/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.parser.xml;

import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.nodelet.NodeletParser;
import com.aspectran.utils.nodelet.SubnodeParser;

class TemplateNodeParser
implements SubnodeParser {
    TemplateNodeParser() {
    }

    @Override
    public void parse(@NonNull String xpath, @NonNull NodeletParser parser) {
        AspectranNodeParser nodeParser = (AspectranNodeParser)parser.getNodeParser();
        ActivityRuleAssistant assistant = nodeParser.getAssistant();
        parser.setXpath(xpath + "/template");
        parser.addNodelet(attrs -> {
            String id = StringUtils.emptyToNull((String)attrs.get("id"));
            String engine = StringUtils.emptyToNull((String)attrs.get("engine"));
            String name = StringUtils.emptyToNull((String)attrs.get("name"));
            String file = StringUtils.emptyToNull((String)attrs.get("file"));
            String resource = StringUtils.emptyToNull((String)attrs.get("resource"));
            String url = StringUtils.emptyToNull((String)attrs.get("url"));
            String style = (String)attrs.get("style");
            String contentType = (String)attrs.get("contentType");
            String encoding = (String)attrs.get("encoding");
            Boolean noCache = BooleanUtils.toNullableBooleanObject((String)attrs.get("noCache"));
            TemplateRule templateRule = TemplateRule.newInstance(id, engine, name, file, resource, url, style, null, contentType, encoding, noCache);
            parser.pushObject(templateRule);
        });
        parser.addEndNodelet(text -> {
            TemplateRule templateRule = (TemplateRule)parser.popObject();
            TemplateRule.updateTemplateSource(templateRule, text);
            assistant.addTemplateRule(templateRule);
        });
    }
}

