/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.util;

import com.aspectran.core.context.rule.assistant.DefaultSettings;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Namespace {
    @Nullable
    public static String[] splitNamespace(String namespace) {
        if (!StringUtils.hasText(namespace)) {
            return null;
        }
        namespace = namespace.trim();
        boolean absolutelyStart = namespace.startsWith("/");
        boolean absolutelyEnd = namespace.endsWith("/");
        ArrayList<String> list = new ArrayList<String>();
        if (absolutelyStart) {
            list.add(null);
        }
        StringTokenizer st = new StringTokenizer(namespace, "./");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        if (absolutelyEnd) {
            list.add(null);
        }
        return list.toArray(new String[0]);
    }

    public static String applyNamespace(String[] nameArray, String lastName) {
        if (nameArray == null || nameArray.length == 0) {
            return lastName;
        }
        StringBuilder sb = new StringBuilder();
        for (String name : nameArray) {
            if (name == null || name.isEmpty()) continue;
            if (!sb.isEmpty()) {
                sb.append(".");
            }
            sb.append(name);
        }
        if (lastName != null && !lastName.isEmpty()) {
            if (!sb.isEmpty()) {
                sb.append(".");
            }
            sb.append(lastName);
        }
        return sb.toString();
    }

    public static String applyNamespaceForTranslet(String[] nameArray, String lastName) {
        if (nameArray == null || nameArray.length == 0) {
            return lastName;
        }
        StringBuilder sb = new StringBuilder();
        for (String name : nameArray) {
            if (name == null || name.isEmpty()) continue;
            if (!sb.isEmpty()) {
                sb.append("/");
            }
            sb.append(name);
        }
        if (lastName != null && !lastName.isEmpty()) {
            if (!sb.isEmpty() && !lastName.startsWith("/")) {
                sb.append("/");
            }
            sb.append(lastName);
        }
        if (nameArray[0] == null && sb.charAt(0) != '/') {
            sb.insert(0, "/");
        }
        if (nameArray.length > 1 && nameArray[nameArray.length - 1] == null && sb.charAt(sb.length() - 1) != '/') {
            sb.append("/");
        }
        return sb.toString();
    }

    public static String applyTransletNamePattern(DefaultSettings defaultSettings, String transletName) {
        return Namespace.applyTransletNamePattern(defaultSettings, transletName, false);
    }

    public static String applyTransletNamePattern(DefaultSettings defaultSettings, String transletName, boolean absolutely) {
        String prefix = null;
        String suffix = null;
        if (defaultSettings != null) {
            prefix = defaultSettings.getTransletNamePrefix();
            suffix = defaultSettings.getTransletNameSuffix();
        }
        return Namespace.applyTransletNamePattern(prefix, transletName, suffix, absolutely);
    }

    public static String applyTransletNamePattern(String prefix, String transletName, String suffix, boolean absolutely) {
        if (prefix == null && suffix == null) {
            return transletName;
        }
        if (absolutely && StringUtils.startsWith(transletName, '/')) {
            return transletName;
        }
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        if (transletName != null && !transletName.isEmpty()) {
            sb.append(transletName);
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

