/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.scheduler.service;

import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.config.AcceptableConfig;
import com.aspectran.core.context.config.SchedulerConfig;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.params.TriggerExpressionParameters;
import com.aspectran.core.context.rule.type.TriggerType;
import com.aspectran.core.scheduler.service.ActivityLauncherJob;
import com.aspectran.core.scheduler.service.QuartzJobListener;
import com.aspectran.core.scheduler.service.SchedulerService;
import com.aspectran.core.scheduler.service.SchedulerServiceException;
import com.aspectran.core.service.AbstractServiceLifeCycle;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.RequestAcceptor;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public abstract class AbstractSchedulerService
extends AbstractServiceLifeCycle
implements SchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSchedulerService.class);
    private final Set<Scheduler> schedulers = new HashSet<Scheduler>();
    private final Map<String, Scheduler> schedulerMap = new HashMap<String, Scheduler>();
    private int startDelaySeconds = 0;
    private boolean waitOnShutdown = false;
    private RequestAcceptor requestAcceptor;

    AbstractSchedulerService(CoreService parentService) {
        super(parentService);
        Assert.notNull((Object)parentService, "parentService must not be null");
    }

    @Override
    public ActivityContext getActivityContext() {
        Assert.state(this.getParentService().getActivityContext() != null, "No ActivityContext configured yet");
        return this.getParentService().getActivityContext();
    }

    @Override
    public int getStartDelaySeconds() {
        return this.startDelaySeconds;
    }

    public void setStartDelaySeconds(int startDelaySeconds) {
        this.startDelaySeconds = startDelaySeconds;
    }

    @Override
    public boolean isWaitOnShutdown() {
        return this.waitOnShutdown;
    }

    public void setWaitOnShutdown(boolean waitOnShutdown) {
        this.waitOnShutdown = waitOnShutdown;
    }

    @Override
    public boolean isDerived() {
        return true;
    }

    public boolean isAcceptable(String requestName) {
        return this.requestAcceptor == null || this.requestAcceptor.isAcceptable(requestName);
    }

    protected void setRequestAcceptor(RequestAcceptor requestAcceptor) {
        this.requestAcceptor = requestAcceptor;
    }

    protected Set<Scheduler> getSchedulers() {
        return this.schedulers;
    }

    protected Scheduler getScheduler(String scheduleId) {
        return this.schedulerMap.get(scheduleId);
    }

    private void addScheduler(String scheduleId, Scheduler scheduler) {
        Assert.notNull((Object)scheduler, "scheduler must not be null");
        this.schedulers.add(scheduler);
        this.schedulerMap.put(scheduleId, scheduler);
    }

    private void clearSchedulers() {
        this.schedulers.clear();
        this.schedulerMap.clear();
    }

    @Override
    protected void doStart() throws Exception {
        try {
            this.buildSchedulers();
            for (Scheduler scheduler : this.getSchedulers()) {
                logger.info("Starting scheduler '" + scheduler.getSchedulerName() + "'");
                QuartzJobListener defaultJobListener = new QuartzJobListener();
                scheduler.getListenerManager().addJobListener((JobListener)defaultJobListener);
                if (this.getStartDelaySeconds() > 0) {
                    scheduler.startDelayed(this.getStartDelaySeconds());
                    continue;
                }
                scheduler.start();
            }
        }
        catch (Exception e) {
            throw new SchedulerServiceException("Could not start DefaultSchedulerService", e);
        }
    }

    @Override
    protected void doStop() throws Exception {
        try {
            for (Scheduler scheduler : this.getSchedulers()) {
                if (scheduler.isShutdown()) continue;
                logger.info("Shutting down the scheduler '" + scheduler.getSchedulerName() + "' with waitForJobsToComplete=" + this.isWaitOnShutdown());
                scheduler.shutdown(this.isWaitOnShutdown());
            }
            this.clearSchedulers();
        }
        catch (Exception e) {
            throw new SchedulerServiceException("Could not shutdown DefaultSchedulerService", e);
        }
    }

    private void buildSchedulers() throws SchedulerServiceException {
        ScheduleRuleRegistry scheduleRuleRegistry = this.getActivityContext().getScheduleRuleRegistry();
        if (scheduleRuleRegistry == null) {
            return;
        }
        Collection<ScheduleRule> scheduleRules = scheduleRuleRegistry.getScheduleRules();
        if (scheduleRules == null || scheduleRules.isEmpty()) {
            return;
        }
        try {
            for (ScheduleRule scheduleRule : scheduleRules) {
                Scheduler scheduler = this.createScheduler(scheduleRule);
                this.addScheduler(scheduleRule.getId(), scheduler);
            }
        }
        catch (Exception e) {
            throw new SchedulerServiceException("Could not start DefaultSchedulerService", e);
        }
    }

    @NonNull
    private Scheduler createScheduler(@NonNull ScheduleRule scheduleRule) throws SchedulerException {
        Scheduler scheduler = null;
        if (scheduleRule.getSchedulerBeanClass() != null) {
            scheduler = (Scheduler)this.getActivityContext().getBeanRegistry().getBean(scheduleRule.getSchedulerBeanClass());
        } else if (scheduleRule.getSchedulerBeanId() != null) {
            scheduler = (Scheduler)this.getActivityContext().getBeanRegistry().getBean(scheduleRule.getSchedulerBeanId());
        }
        if (scheduler == null) {
            throw new SchedulerServiceException("No such scheduler bean; Invalid ScheduleRule " + String.valueOf(scheduleRule));
        }
        List<ScheduledJobRule> jobRuleList = scheduleRule.getScheduledJobRuleList();
        for (ScheduledJobRule jobRule : jobRuleList) {
            if (this.isAcceptable(jobRule.getTransletName())) {
                JobDetail jobDetail = this.createJobDetail(jobRule);
                if (jobDetail == null) continue;
                String triggerName = jobDetail.getKey().getName();
                String triggerGroup = scheduleRule.getId();
                Trigger trigger = this.createTrigger(triggerName, triggerGroup, scheduleRule, this.getStartDelaySeconds());
                scheduler.scheduleJob(jobDetail, trigger);
                continue;
            }
            logger.warn("Unexposed translet [" + jobRule.getTransletName() + "] in ScheduleRule " + String.valueOf(scheduleRule));
        }
        return scheduler;
    }

    private JobDetail createJobDetail(@NonNull ScheduledJobRule jobRule) {
        String jobName = jobRule.getTransletName();
        String jobGroup = jobRule.getScheduleRule().getId();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("SERVICE", (Object)this);
        jobDataMap.put("JOB_RULE", (Object)jobRule);
        return JobBuilder.newJob(ActivityLauncherJob.class).withIdentity(jobName, jobGroup).setJobData(jobDataMap).build();
    }

    private Trigger createTrigger(String name, String group, @NonNull ScheduleRule scheduleRule, int startDelaySeconds) {
        TriggerExpressionParameters expressionParameters = scheduleRule.getTriggerExpressionParameters();
        int startDelaySecondsToUse = startDelaySeconds;
        if (expressionParameters.getStartDelaySeconds() != null) {
            startDelaySecondsToUse += expressionParameters.getStartDelaySeconds().intValue();
        }
        Date firstFireTime = startDelaySecondsToUse > 0 ? new Date(System.currentTimeMillis() + (long)startDelaySecondsToUse * 1000L) : new Date();
        if (scheduleRule.getTriggerType() == TriggerType.SIMPLE) {
            Long intervalInMilliseconds = expressionParameters.getIntervalInMilliseconds();
            Integer intervalInSeconds = expressionParameters.getIntervalInSeconds();
            Integer intervalInMinutes = expressionParameters.getIntervalInMinutes();
            Integer intervalInHours = expressionParameters.getIntervalInHours();
            Integer repeatCount = expressionParameters.getRepeatCount();
            Boolean repeatForever = expressionParameters.getRepeatForever();
            SimpleScheduleBuilder builder = SimpleScheduleBuilder.simpleSchedule();
            if (intervalInMilliseconds != null) {
                builder.withIntervalInMilliseconds(intervalInMilliseconds.longValue());
            }
            if (intervalInSeconds != null) {
                builder.withIntervalInSeconds(intervalInSeconds.intValue());
            }
            if (intervalInMinutes != null) {
                builder.withIntervalInMinutes(intervalInMinutes.intValue());
            }
            if (intervalInHours != null) {
                builder.withIntervalInHours(intervalInHours.intValue());
            }
            if (repeatCount != null) {
                builder.withRepeatCount(repeatCount.intValue());
            }
            if (Boolean.TRUE.equals(repeatForever)) {
                builder.repeatForever();
            }
            return TriggerBuilder.newTrigger().withIdentity(name, group).startAt(firstFireTime).withSchedule((ScheduleBuilder)builder).build();
        }
        String expression = expressionParameters.getExpression();
        CronScheduleBuilder cronSchedule = CronScheduleBuilder.cronSchedule((String)expression);
        return TriggerBuilder.newTrigger().withIdentity(name, group).startAt(firstFireTime).withSchedule((ScheduleBuilder)cronSchedule).build();
    }

    protected void configure(@NonNull SchedulerConfig schedulerConfig) {
        boolean waitOnShutdown;
        int startDelaySeconds = schedulerConfig.getStartDelaySeconds();
        if (startDelaySeconds == -1) {
            startDelaySeconds = 3;
            if (logger.isDebugEnabled()) {
                logger.debug("Scheduler option 'startDelaySeconds' is not specified, defaulting to 3 seconds");
            }
        }
        if (waitOnShutdown = schedulerConfig.isWaitOnShutdown()) {
            this.setWaitOnShutdown(true);
        }
        this.setStartDelaySeconds(startDelaySeconds);
        AcceptableConfig acceptableConfig = schedulerConfig.getAcceptableConfig();
        if (acceptableConfig != null) {
            this.setRequestAcceptor(new RequestAcceptor(acceptableConfig));
        }
    }
}

