/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.scheduler.service;

import com.aspectran.core.scheduler.service.AbstractSchedulerService;
import com.aspectran.core.scheduler.service.SchedulerServiceException;
import com.aspectran.core.service.CoreService;
import org.quartz.Scheduler;
import org.quartz.impl.matchers.GroupMatcher;

public class DefaultSchedulerService
extends AbstractSchedulerService {
    DefaultSchedulerService(CoreService parentService) {
        super(parentService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseAll() {
        Object object = this.getLock();
        synchronized (object) {
            try {
                for (Scheduler scheduler : this.getSchedulers()) {
                    scheduler.pauseAll();
                }
            }
            catch (Exception e) {
                throw new SchedulerServiceException("Could not pause all schedulers", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAll() {
        Object object = this.getLock();
        synchronized (object) {
            try {
                for (Scheduler scheduler : this.getSchedulers()) {
                    scheduler.resumeAll();
                }
            }
            catch (Exception e) {
                throw new SchedulerServiceException("Could not resume all schedulers", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(String scheduleId) throws SchedulerServiceException {
        Object object = this.getLock();
        synchronized (object) {
            try {
                Scheduler scheduler = this.getScheduler(scheduleId);
                if (scheduler != null && scheduler.isStarted()) {
                    scheduler.pauseJobs(GroupMatcher.jobGroupEquals((String)scheduleId));
                }
            }
            catch (Exception e) {
                throw new SchedulerServiceException("Could not pause scheduler '" + scheduleId + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void resume(String scheduleId) throws SchedulerServiceException {
        Object object = this.getLock();
        synchronized (object) {
            try {
                Scheduler scheduler = this.getScheduler(scheduleId);
                if (scheduler != null && scheduler.isStarted()) {
                    scheduler.resumeJobs(GroupMatcher.jobGroupEquals((String)scheduleId));
                }
            }
            catch (Exception e) {
                throw new SchedulerServiceException("Could not resume scheduler '" + scheduleId + "'", e);
            }
        }
    }
}

