/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.scheduler.service;

import com.aspectran.core.context.config.SchedulerConfig;
import com.aspectran.core.scheduler.service.DefaultSchedulerService;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public class DefaultSchedulerServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulerServiceBuilder.class);

    @NonNull
    public static DefaultSchedulerService build(CoreService parentService, SchedulerConfig schedulerConfig) {
        Assert.notNull((Object)parentService, "parentService must not be null");
        Assert.notNull((Object)schedulerConfig, "schedulerConfig must not be null");
        DefaultSchedulerService schedulerService = new DefaultSchedulerService(parentService);
        schedulerService.configure(schedulerConfig);
        DefaultSchedulerServiceBuilder.setServiceStateListener(schedulerService);
        return schedulerService;
    }

    private static void setServiceStateListener(final @NonNull DefaultSchedulerService schedulerService) {
        schedulerService.setServiceStateListener(new ServiceStateListener(){

            @Override
            public void started() {
            }

            @Override
            public void stopped() {
            }

            @Override
            public void paused(long millis) {
                logger.warn(schedulerService.getServiceName() + " does not support pausing for a certain period of time");
            }

            @Override
            public void paused() {
                schedulerService.pauseAll();
            }

            @Override
            public void resumed() {
                schedulerService.resumeAll();
            }
        });
    }
}

