/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.scheduler.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;

public class JobActivityReport {
    private static final Logger logger = LoggerFactory.getLogger(JobActivityReport.class);
    private final JobExecutionContext jobExecutionContext;
    private final JobExecutionException jobException;

    public JobActivityReport(JobExecutionContext jobExecutionContext, JobExecutionException jobException) {
        this.jobExecutionContext = jobExecutionContext;
        this.jobException = jobException;
    }

    public void reporting() {
        try {
            JobDetail jobDetail = this.jobExecutionContext.getJobDetail();
            JobKey key = jobDetail.getKey();
            String jobName = key.getName();
            String jobGroup = key.getGroup();
            StringBuilder sb = new StringBuilder(768);
            sb.append("Result of job execution");
            if (this.jobException != null) {
                sb.append(" (Failed)");
            }
            sb.append(System.lineSeparator());
            sb.append("----------------------------------------------------------------------------").append(System.lineSeparator());
            sb.append("- Job Group           : ").append(jobGroup).append(System.lineSeparator());
            sb.append("- Job Name            : ").append(jobName).append(System.lineSeparator());
            sb.append("- Scheduled Fire Time : ").append(this.formatDate(this.jobExecutionContext.getScheduledFireTime())).append(System.lineSeparator());
            sb.append("- Actual Fire Time    : ").append(this.formatDate(this.jobExecutionContext.getFireTime())).append(System.lineSeparator());
            sb.append("- Run Time            : ").append(this.jobExecutionContext.getJobRunTime()).append(" milliseconds").append(System.lineSeparator());
            sb.append("- Previous Fire Time  : ").append(this.jobExecutionContext.getPreviousFireTime() != null ? this.formatDate(this.jobExecutionContext.getPreviousFireTime()) : "N/A").append(System.lineSeparator());
            sb.append("- Next Fire Time      : ").append(this.jobExecutionContext.getNextFireTime() != null ? this.formatDate(this.jobExecutionContext.getNextFireTime()) : "N/A").append(System.lineSeparator());
            sb.append("- Recovering          : ").append(this.jobExecutionContext.isRecovering()).append(System.lineSeparator());
            sb.append("- Re-fire Count       : ").append(this.jobExecutionContext.getRefireCount()).append(System.lineSeparator());
            sb.append("----------------------------------------------------------------------------").append(System.lineSeparator());
            Activity activity = (Activity)this.jobExecutionContext.getResult();
            if (activity != null) {
                String result = activity.getResponseAdapter().getWriter().toString();
                if (StringUtils.hasLength(result)) {
                    sb.append(result).append(System.lineSeparator());
                    sb.append("----------------------------------------------------------------------------").append(System.lineSeparator());
                }
            } else {
                JobDataMap jobDataMap = jobDetail.getJobDataMap();
                ScheduledJobRule jobRule = (ScheduledJobRule)jobDataMap.get((Object)"JOB_RULE");
                if (jobRule.isDisabled()) {
                    sb.append("- Execution of this job is disabled.").append(System.lineSeparator());
                    sb.append("----------------------------------------------------------------------------").append(System.lineSeparator());
                }
            }
            if (this.jobException != null) {
                String msg = ExceptionUtils.getRootCause((Throwable)this.jobException).getMessage();
                sb.append("[ERROR] ").append(msg.trim()).append(System.lineSeparator());
                logger.error(sb.toString().trim(), (Throwable)this.jobException);
            } else if (logger.isDebugEnabled()) {
                logger.debug(sb.toString());
            }
        }
        catch (IOException e) {
            logger.warn("Job activity reporting failed", e);
        }
    }

    @NonNull
    private String formatDate(@NonNull Date date) {
        LocalDateTime ldt = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(ldt);
    }
}

