/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.builder.ActivityContextBuilder;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.scheduler.service.DefaultSchedulerServiceBuilder;
import com.aspectran.core.scheduler.service.SchedulerService;
import com.aspectran.core.service.AbstractServiceLifeCycle;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.RequestAcceptor;
import com.aspectran.core.service.ServiceLifeCycle;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.annotation.jsr305.Nullable;

public abstract class AbstractCoreService
extends AbstractServiceLifeCycle
implements CoreService {
    private final boolean derived;
    private String basePath;
    private AspectranConfig aspectranConfig;
    private ActivityContextBuilder activityContextBuilder;
    private ActivityContext activityContext;
    private ClassLoader serviceClassLoader;
    private ClassLoader altClassLoader;
    private SchedulerService schedulerService;
    private RequestAcceptor requestAcceptor;

    public AbstractCoreService() {
        this(null, false);
    }

    public AbstractCoreService(CoreService parentService, boolean derived) {
        super(parentService);
        if (parentService == null) {
            Assert.isTrue(!derived, "When in derived mode, parentService must not be null");
        } else if (derived) {
            Assert.state(parentService.getActivityContext() != null, "Oops! No ActivityContext configured");
        }
        this.derived = derived;
        if (parentService != null && derived) {
            this.setAspectranConfig(parentService.getAspectranConfig());
            this.setActivityContext(parentService.getActivityContext());
        }
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    @Override
    public String getServiceName() {
        if (this.getActivityContext() != null && this.getActivityContext().getName() != null) {
            return ObjectUtils.simpleIdentityToString(this, this.getActivityContext().getName());
        }
        return super.getServiceName();
    }

    @Override
    public ServiceLifeCycle getServiceLifeCycle() {
        return this;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    protected void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public AspectranConfig getAspectranConfig() {
        return this.aspectranConfig;
    }

    protected void setAspectranConfig(AspectranConfig aspectranConfig) {
        this.aspectranConfig = aspectranConfig;
    }

    protected boolean hasActivityContextBuilder() {
        return this.activityContextBuilder != null;
    }

    protected ActivityContextBuilder getActivityContextBuilder() {
        Assert.state(this.hasActivityContextBuilder(), "No ActivityContextLoader configured");
        return this.activityContextBuilder;
    }

    protected void setActivityContextBuilder(ActivityContextBuilder activityContextBuilder) {
        Assert.state(!this.hasActivityContextBuilder(), "ActivityContextBuilder is already configured");
        this.activityContextBuilder = activityContextBuilder;
    }

    @Override
    @Nullable
    public ApplicationAdapter getApplicationAdapter() {
        if (this.getRootService().getActivityContext() != null) {
            return this.getRootService().getActivityContext().getApplicationAdapter();
        }
        return null;
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.activityContext;
    }

    protected void setActivityContext(ActivityContext activityContext) {
        this.activityContext = activityContext;
    }

    @Override
    public Activity getDefaultActivity() {
        Assert.state(this.getActivityContext() != null, "No ActivityContext configured yet");
        return this.getActivityContext().getDefaultActivity();
    }

    @Override
    public boolean hasServiceClassLoader() {
        return this.serviceClassLoader != null;
    }

    @Override
    @Nullable
    public ClassLoader getServiceClassLoader() {
        if (this.serviceClassLoader != null) {
            return this.serviceClassLoader;
        }
        if (this.activityContext != null) {
            return this.activityContext.getClassLoader();
        }
        if (this.getActivityContextBuilder() != null) {
            return this.getActivityContextBuilder().getClassLoader();
        }
        return null;
    }

    protected void setServiceClassLoader(ClassLoader serviceClassLoader) {
        this.serviceClassLoader = serviceClassLoader;
    }

    @Override
    public ClassLoader getAltClassLoader() {
        return this.altClassLoader;
    }

    public void setAltClassLoader(ClassLoader altClassLoader) {
        this.altClassLoader = altClassLoader;
    }

    @Override
    public SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    protected void buildSchedulerService() {
        Assert.state(this.getAspectranConfig() != null, "AspectranConfig is not set");
        if (this.getAspectranConfig().hasSchedulerConfig() && this.getAspectranConfig().getSchedulerConfig().isEnabled()) {
            this.schedulerService = DefaultSchedulerServiceBuilder.build(this, this.getAspectranConfig().getSchedulerConfig());
        }
    }

    @Override
    public boolean isAcceptable(String requestName) {
        return this.requestAcceptor == null || this.requestAcceptor.isAcceptable(requestName);
    }

    protected void setRequestAcceptor(RequestAcceptor requestAcceptor) {
        this.requestAcceptor = requestAcceptor;
    }
}

