/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceLifeCycle;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractServiceLifeCycle
implements ServiceLifeCycle {
    private final Logger logger = LoggerFactory.getLogger(AbstractServiceLifeCycle.class);
    private final Object lock = new Object();
    private final List<ServiceLifeCycle> derivedServices = new ArrayList<ServiceLifeCycle>();
    private final CoreService rootService;
    private final CoreService parentService;
    private ServiceStateListener serviceStateListener;
    private volatile boolean active;

    public AbstractServiceLifeCycle(@Nullable CoreService parentService) {
        this.parentService = parentService;
        if (parentService != null) {
            this.rootService = parentService.getRootService();
            this.rootService.getServiceLifeCycle().joinDerivedService(this);
        } else {
            this.rootService = (CoreService)((Object)this);
        }
    }

    @Override
    public String getServiceName() {
        return ObjectUtils.simpleIdentityToString(this);
    }

    @Override
    @NonNull
    public CoreService getRootService() {
        return this.rootService;
    }

    @Override
    public CoreService getParentService() {
        return this.parentService;
    }

    @Override
    public boolean isRootService() {
        return this.parentService == null;
    }

    @Override
    public boolean isOrphan() {
        return this.parentService == null || this.parentService.getServiceLifeCycle().isActive();
    }

    @Override
    public void setServiceStateListener(ServiceStateListener serviceStateListener) {
        this.serviceStateListener = serviceStateListener;
    }

    @Override
    public void joinDerivedService(ServiceLifeCycle serviceLifeCycle) {
        this.derivedServices.add(serviceLifeCycle);
    }

    @Override
    public void withdrawDerivedService(@NonNull ServiceLifeCycle serviceLifeCycle) {
        Assert.state(serviceLifeCycle.isDerived(), "Not derived service: " + String.valueOf(serviceLifeCycle));
        Assert.state(!serviceLifeCycle.isActive(), "Not yet stopped service: " + String.valueOf(serviceLifeCycle));
        this.derivedServices.remove(serviceLifeCycle);
    }

    @Override
    public void leaveFromRootService() {
        if (this.isDerived()) {
            this.getRootService().getServiceLifeCycle().withdrawDerivedService(this);
        }
    }

    protected void clearDerivedServices() {
        this.derivedServices.clear();
    }

    protected Object getLock() {
        return this.lock;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doStop() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            Assert.state(!this.active, this.getServiceName() + " has already started");
            this.logger.info("Starting " + this.getServiceName());
            this.doStart();
            this.logger.info("Started " + this.getServiceName());
            for (ServiceLifeCycle serviceLifeCycle : this.derivedServices) {
                serviceLifeCycle.start();
            }
            if (this.serviceStateListener != null) {
                this.serviceStateListener.started();
            }
            this.active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.getServiceName() + " is not running, will do nothing");
                }
                return;
            }
            if (this.serviceStateListener != null) {
                try {
                    this.serviceStateListener.paused();
                    this.serviceStateListener.stopped();
                }
                catch (Exception e) {
                    this.logger.warn(e);
                }
            }
            for (ServiceLifeCycle serviceLifeCycle : this.derivedServices) {
                serviceLifeCycle.stop();
            }
            try {
                this.logger.info("Stopping " + this.getServiceName());
                this.doStop();
                this.logger.info("Stopped " + this.getServiceName());
            }
            catch (Exception e) {
                this.logger.error(this.getServiceName() + " did not stop normally", e);
            }
            this.active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            Assert.state(this.isRootService(), "Must be a root service to restart");
            Assert.state(this.active, this.getServiceName() + " is not yet started");
            this.logger.info("Restarting " + this.getServiceName());
            if (this.serviceStateListener != null) {
                this.serviceStateListener.paused();
            }
            for (ServiceLifeCycle serviceLifeCycle : this.derivedServices) {
                serviceLifeCycle.stop();
            }
            this.active = false;
            this.doStop();
            if (this.serviceStateListener != null) {
                try {
                    this.serviceStateListener.stopped();
                }
                catch (Exception e) {
                    this.logger.warn(e);
                }
            }
            this.doStart();
            this.active = true;
            this.logger.info("Restarted " + this.getServiceName());
            for (ServiceLifeCycle serviceLifeCycle : this.derivedServices) {
                serviceLifeCycle.start();
            }
            if (this.serviceStateListener != null) {
                this.serviceStateListener.started();
            }
        }
    }

    @Override
    public void restart(String message) throws Exception {
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                this.logger.warn(this.getServiceName() + " is not yet started");
                return;
            }
            if (!this.isDerived()) {
                for (ServiceLifeCycle serviceLifeCycle : this.derivedServices) {
                    serviceLifeCycle.pause();
                }
            }
            if (this.serviceStateListener != null) {
                this.serviceStateListener.paused();
            }
            this.logger.info("Pause " + this.getServiceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(long timeout) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                this.logger.warn(this.getServiceName() + " is not yet started");
                return;
            }
            if (!this.isDerived()) {
                for (ServiceLifeCycle serviceLifeCycle : this.derivedServices) {
                    serviceLifeCycle.pause(timeout);
                }
            }
            if (this.serviceStateListener != null) {
                this.serviceStateListener.paused(timeout);
            }
            this.logger.info("Pause " + this.getServiceName() + ", resume after " + timeout + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                this.logger.warn(this.getServiceName() + " is not yet started");
                return;
            }
            if (!this.isDerived()) {
                for (ServiceLifeCycle serviceLifeCycle : this.derivedServices) {
                    serviceLifeCycle.resume();
                }
            }
            if (this.serviceStateListener != null) {
                this.serviceStateListener.resumed();
            }
            this.logger.info("Resume " + this.getServiceName());
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isBusy() {
        return false;
    }
}

