/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.resource.SiblingClassLoader;
import com.aspectran.core.service.CoreService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class CoreServiceHolder {
    private static final Set<CoreService> allServices = new CopyOnWriteArraySet<CoreService>();
    private static final Map<ClassLoader, CoreService> servicesByLoader = new HashMap<ClassLoader, CoreService>();
    private static final Map<Class<?>, CoreService> servicesByClass = new HashMap();
    private static volatile CoreService currentService;

    public static synchronized void hold(CoreService service) {
        Assert.notNull((Object)service, "service must not be null");
        Assert.state(service.getActivityContext() != null, "No ActivityContext in service: " + String.valueOf(service));
        Assert.state(!allServices.contains(service), "Already registered service: " + String.valueOf(service));
        ClassLoader classLoader = service.getServiceClassLoader();
        if (classLoader != null) {
            allServices.add(service);
            if (classLoader == CoreServiceHolder.class.getClassLoader()) {
                currentService = service;
            } else {
                servicesByLoader.put(classLoader, service);
            }
            if (service.getAltClassLoader() != null) {
                CoreServiceHolder.hold(service.getAltClassLoader(), service);
            }
        }
    }

    public static synchronized void hold(ClassLoader classLoader, CoreService service) {
        Assert.notNull((Object)classLoader, "classLoader must not be null");
        Assert.notNull((Object)service, "service must not be null");
        Assert.state(allServices.contains(service), "Not a registered service: " + String.valueOf(service));
        CoreService existing = servicesByLoader.get(classLoader);
        Assert.state(existing != service, "The classloader is already mapped to another service: " + String.valueOf(service));
        servicesByLoader.put(classLoader, service);
    }

    public static synchronized void hold(Class<?> clazz, CoreService service) {
        Assert.notNull(clazz, "clazz must not be null");
        Assert.notNull((Object)service, "service must not be null");
        Assert.state(allServices.contains(service), "Not a registered service: " + String.valueOf(service));
        CoreService existing = servicesByClass.get(clazz);
        Assert.state(existing != service, "The class is already mapped to another service: " + String.valueOf(service));
        servicesByClass.put(clazz, service);
    }

    public static synchronized void release(CoreService service) {
        Assert.notNull((Object)service, "service must not be null");
        Assert.state(allServices.contains(service), "Not a registered service: " + String.valueOf(service));
        allServices.remove(service);
        if (currentService != null && currentService == service) {
            currentService = null;
        }
        servicesByLoader.entrySet().removeIf(entry -> service.equals(entry.getValue()));
        servicesByClass.entrySet().removeIf(entry -> service.equals(entry.getValue()));
    }

    public static CoreService acquire() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            CoreService service = servicesByLoader.get(classLoader);
            if (service == null && !(classLoader instanceof SiblingClassLoader)) {
                service = servicesByLoader.get(classLoader.getParent());
            }
            if (service != null) {
                return service;
            }
        }
        return currentService;
    }

    public static CoreService acquire(Class<?> clazz) {
        CoreService service = servicesByClass.get(clazz);
        if (service == null) {
            service = CoreServiceHolder.acquire();
        }
        return service;
    }

    @Nullable
    public static ActivityContext findActivityContext() {
        CoreService service = CoreServiceHolder.acquire();
        return service != null ? service.getActivityContext() : null;
    }

    @Nullable
    public static ActivityContext findActivityContext(Class<?> clazz) {
        CoreService service = CoreServiceHolder.acquire(clazz);
        return service != null ? service.getActivityContext() : null;
    }

    @Nullable
    public static ActivityContext findActivityContext(String contextName) {
        Assert.notNull((Object)contextName, "contextName must not be null");
        for (CoreService service : allServices) {
            ActivityContext activityContext = service.getActivityContext();
            if (activityContext == null || !contextName.equals(activityContext.getName())) continue;
            return activityContext;
        }
        return null;
    }
}

