/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.component.Component;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.builder.ActivityContextBuilderException;
import com.aspectran.core.context.builder.HybridActivityContextBuilder;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.SystemConfig;
import com.aspectran.core.service.AbstractCoreService;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.utils.Assert;
import com.aspectran.utils.FileLocker;
import com.aspectran.utils.InsufficientEnvironmentException;
import com.aspectran.utils.ShutdownHook;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public class DefaultCoreService
extends AbstractCoreService {
    private final Logger logger = LoggerFactory.getLogger(DefaultCoreService.class);
    private FileLocker fileLocker;
    private ShutdownHook.Manager shutdownHookManager;

    public DefaultCoreService() {
    }

    public DefaultCoreService(CoreService parentService, boolean derived) {
        super(parentService, derived);
    }

    protected void configure(@NonNull AspectranConfig aspectranConfig) {
        Assert.state(!this.isDerived(), "Must not be called for derived services");
        Assert.state(!this.hasActivityContextBuilder(), "prepare() method can be called only once");
        try {
            this.setAspectranConfig(aspectranConfig);
            SystemConfig systemConfig = aspectranConfig.getSystemConfig();
            if (systemConfig != null) {
                for (String key : systemConfig.getPropertyKeys()) {
                    String value = systemConfig.getProperty(key);
                    if (value == null) continue;
                    System.setProperty(key, value);
                }
            }
            ContextConfig contextConfig = aspectranConfig.getContextConfig();
            if (this.isRootService()) {
                if (this.getBasePath() == null && contextConfig != null && contextConfig.hasBasePath()) {
                    this.setBasePath(contextConfig.getBasePath());
                }
            } else {
                this.setBasePath(this.getParentService().getBasePath());
            }
            HybridActivityContextBuilder activityContextBuilder = new HybridActivityContextBuilder(this);
            activityContextBuilder.configure(contextConfig);
            this.setActivityContextBuilder(activityContextBuilder);
            if (this.getBasePath() == null) {
                this.setBasePath(activityContextBuilder.getBasePath());
            }
            if (this.isRootService() && contextConfig != null && contextConfig.isSingleton()) {
                if (activityContextBuilder.hasOwnBasePath()) {
                    this.acquireSingletonLock();
                } else {
                    this.logger.warn("Since no base directory is explicitly specified, no singleton lock is applied");
                }
            }
        }
        catch (Exception e) {
            throw new CoreServiceException("Unable to prepare the service", e);
        }
    }

    protected void buildActivityContext() throws ActivityContextBuilderException {
        Assert.state(this.getActivityContext() == null, "ActivityContext is already built; Must destroy the current ActivityContext before reloading");
        ActivityContext activityContext = this.getActivityContextBuilder().build();
        this.setActivityContext(activityContext);
        try {
            ((Component)((Object)activityContext)).initialize();
        }
        catch (Exception e) {
            throw new ActivityContextBuilderException("Failed to initialize ActivityContext", e);
        }
    }

    protected void destroyActivityContext() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Destroying all cached resources...");
        }
        this.getActivityContextBuilder().destroy();
        this.setActivityContext(null);
    }

    protected void afterContextLoaded() throws Exception {
    }

    protected void beforeContextDestroy() {
    }

    @Override
    protected void doStart() throws Exception {
        if (!this.isDerived()) {
            this.buildActivityContext();
            this.buildSchedulerService();
            this.afterContextLoaded();
        }
    }

    @Override
    protected void doStop() {
        if (!this.isDerived()) {
            this.clearDerivedServices();
            this.beforeContextDestroy();
            this.destroyActivityContext();
        }
    }

    @Override
    public void start() throws Exception {
        if (this.isRootService()) {
            this.registerShutdownTask();
        }
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.isRootService()) {
            this.releaseSingletonLock();
            this.removeShutdownTask();
            this.getActivityContextBuilder().clear();
        }
    }

    private void acquireSingletonLock() throws Exception {
        Assert.state(this.fileLocker == null, "Singleton lock is already configured");
        this.fileLocker = new FileLocker(this.getBasePath());
        if (!this.fileLocker.lock()) {
            throw new InsufficientEnvironmentException("Another instance of Aspectran is already running; Only one instance is allowed (context.singleton is set to true)");
        }
    }

    private void releaseSingletonLock() {
        if (this.fileLocker != null) {
            try {
                this.fileLocker.release();
                this.fileLocker = null;
            }
            catch (Exception e) {
                this.logger.warn("Unable to release singleton lock: " + String.valueOf(e));
            }
        }
    }

    private void registerShutdownTask() {
        this.shutdownHookManager = ShutdownHook.Manager.create(new ShutdownHook.Task(){

            @Override
            public void run() throws Exception {
                if (DefaultCoreService.this.isActive()) {
                    DefaultCoreService.super.stop();
                    DefaultCoreService.this.releaseSingletonLock();
                }
            }

            public String toString() {
                return "Stop " + DefaultCoreService.this.getServiceName();
            }
        });
    }

    private void removeShutdownTask() {
        if (this.shutdownHookManager != null) {
            this.shutdownHookManager.remove();
            this.shutdownHookManager = null;
        }
    }
}

