/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.service;

import com.aspectran.core.context.config.AcceptableConfig;
import com.aspectran.utils.Assert;
import com.aspectran.utils.wildcard.RelativeComplementWildcardPatterns;

public class RequestAcceptor {
    private final RelativeComplementWildcardPatterns acceptableRequestNamePatterns;

    public RequestAcceptor(AcceptableConfig acceptableConfig) {
        Assert.notNull((Object)acceptableConfig, "acceptableConfig must not be null");
        String[] includePatterns = acceptableConfig.getIncludePatterns();
        String[] excludePatterns = acceptableConfig.getExcludePatterns();
        this.acceptableRequestNamePatterns = includePatterns != null && includePatterns.length > 0 || excludePatterns != null && excludePatterns.length > 0 ? RelativeComplementWildcardPatterns.of(includePatterns, excludePatterns, '/') : null;
    }

    public boolean isAcceptable(String requestName) {
        return this.acceptableRequestNamePatterns == null || this.acceptableRequestNamePatterns.matches(requestName);
    }
}

