/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.locale;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.utils.LocaleUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Locale;
import java.util.TimeZone;

public class LocaleChangeInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LocaleChangeInterceptor.class);
    public static final String DEFAULT_LOCALE_PARAM_NAME = "locale";
    public static final String DEFAULT_TIMEZONE_PARAM_NAME = "timezone";
    private String localeParamName = "locale";
    private String timeZoneParamName = "timezone";
    @Nullable
    private String[] requestMethods;
    private boolean ignoreInvalidLocale = false;

    public void setLocaleParamName(String localeParamName) {
        this.localeParamName = localeParamName;
    }

    public void setTimeZoneParamName(String timezoneParamName) {
        this.timeZoneParamName = timezoneParamName;
    }

    public String getLocaleParamName() {
        return this.localeParamName;
    }

    public String getTimeZoneParamName() {
        return this.timeZoneParamName;
    }

    public void setRequestMethods(String ... requestMethods) {
        this.requestMethods = requestMethods;
        if (this.requestMethods != null) {
            for (int i = 0; i < this.requestMethods.length; ++i) {
                this.requestMethods[i] = this.requestMethods[i].toUpperCase();
            }
        }
    }

    public String[] getRequestMethods() {
        return this.requestMethods;
    }

    public void setIgnoreInvalidLocale(boolean ignoreInvalidLocale) {
        this.ignoreInvalidLocale = ignoreInvalidLocale;
    }

    public boolean isIgnoreInvalidLocale() {
        return this.ignoreInvalidLocale;
    }

    public void handle(@NonNull Translet translet, LocaleResolver localeResolver) {
        String newTimeZone;
        RequestAdapter requestAdapter = translet.getRequestAdapter();
        if (!this.checkRequestMethod(requestAdapter.getRequestMethod())) {
            return;
        }
        String newLocale = requestAdapter.getParameter(this.getLocaleParamName());
        if (newLocale != null) {
            Locale locale = null;
            try {
                locale = this.parseLocaleValue(newLocale);
            }
            catch (IllegalArgumentException ex) {
                if (this.isIgnoreInvalidLocale()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Ignoring invalid locale value [" + newLocale + "]: " + ex.getMessage());
                    }
                }
                throw ex;
            }
            if (locale != null) {
                if (localeResolver != null) {
                    localeResolver.setLocale(translet, locale);
                } else {
                    requestAdapter.setLocale(locale);
                }
            }
        }
        if ((newTimeZone = requestAdapter.getParameter(this.getTimeZoneParamName())) != null) {
            TimeZone timeZone = null;
            try {
                timeZone = LocaleUtils.parseTimeZoneString(newTimeZone);
            }
            catch (IllegalArgumentException ex) {
                if (this.isIgnoreInvalidLocale()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Ignoring invalid timezone value [" + newTimeZone + "]: " + ex.getMessage());
                    }
                }
                throw ex;
            }
            if (timeZone != null) {
                if (localeResolver != null) {
                    localeResolver.setTimeZone(translet, timeZone);
                } else {
                    requestAdapter.setTimeZone(timeZone);
                }
            }
        }
    }

    private boolean checkRequestMethod(MethodType requestMethod) {
        String[] allowedMethods = this.getRequestMethods();
        if (allowedMethods == null || allowedMethods.length == 0) {
            return true;
        }
        if (requestMethod != null) {
            for (String method : allowedMethods) {
                if (!requestMethod.matches(method)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected Locale parseLocaleValue(String localeValue) {
        return LocaleUtils.parseLocale(localeValue);
    }
}

