/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.i18n.locale;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.support.i18n.locale.AbstractLocaleResolver;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Locale;
import java.util.TimeZone;

public class SessionLocaleResolver
extends AbstractLocaleResolver {
    public static final String LOCALE_SESSION_ATTR_NAME = SessionLocaleResolver.class.getName() + ".LOCALE";
    public static final String TIME_ZONE_SESSION_ATTR_NAME = SessionLocaleResolver.class.getName() + ".TIME_ZONE";

    @Override
    public Locale resolveLocale(@NonNull Translet translet) {
        Locale locale;
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null && (locale = (Locale)sessionAdapter.getAttribute(LOCALE_SESSION_ATTR_NAME)) != null) {
            translet.getRequestAdapter().setLocale(locale);
            return locale;
        }
        return this.determineDefaultLocale(translet);
    }

    @Override
    public TimeZone resolveTimeZone(@NonNull Translet translet) {
        TimeZone timeZone;
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null && (timeZone = (TimeZone)sessionAdapter.getAttribute(TIME_ZONE_SESSION_ATTR_NAME)) != null) {
            translet.getRequestAdapter().setTimeZone(timeZone);
            return timeZone;
        }
        return this.determineDefaultTimeZone(translet);
    }

    @Override
    public void setLocale(@NonNull Translet translet, Locale locale) {
        translet.getRequestAdapter().setLocale(locale);
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null) {
            sessionAdapter.setAttribute(LOCALE_SESSION_ATTR_NAME, locale);
        }
    }

    @Override
    public void setTimeZone(@NonNull Translet translet, TimeZone timeZone) {
        translet.getRequestAdapter().setTimeZone(timeZone);
        SessionAdapter sessionAdapter = translet.getSessionAdapter();
        if (sessionAdapter != null) {
            sessionAdapter.setAttribute(TIME_ZONE_SESSION_ATTR_NAME, timeZone);
        }
    }
}

