/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.support.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.sift.AbstractDiscriminator;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.CoreServiceHolder;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.Map;

public class LoggingGroupDiscriminator
extends AbstractDiscriminator<ILoggingEvent> {
    private static final String DEFAULT_KEY = "LOGGING_GROUP";
    private String key = "LOGGING_GROUP";
    private String defaultValue;

    public String getDiscriminatingValue(@NonNull ILoggingEvent event) {
        ActivityContext context;
        CoreService service;
        String groupName = this.getGroupName(event);
        if (groupName == null && (service = CoreServiceHolder.acquire()) != null && (context = service.getActivityContext()) != null && context.getName() != null) {
            groupName = context.getName();
        }
        if (StringUtils.hasText(groupName)) {
            return groupName;
        }
        return this.defaultValue;
    }

    @Nullable
    private String getGroupName(@NonNull ILoggingEvent event) {
        Map mdcMap = event.getMDCPropertyMap();
        return mdcMap != null ? (String)mdcMap.get(this.key) : null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void start() {
        int errors = 0;
        if (!StringUtils.hasText(this.key)) {
            ++errors;
            this.addError("The 'key' property must be set");
        }
        if (!StringUtils.hasText(this.defaultValue)) {
            ++errors;
            this.addError("The 'defaultValue' property must be set");
        }
        if (errors == 0) {
            super.start();
        }
    }
}

