/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon;

import com.aspectran.core.Aspectran;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.DaemonExecutorConfig;
import com.aspectran.core.context.config.DaemonPollingConfig;
import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.CommandExecutor;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.DaemonCommandRegistry;
import com.aspectran.daemon.command.builtins.QuitCommand;
import com.aspectran.daemon.command.polling.DefaultFileCommander;
import com.aspectran.daemon.command.polling.FileCommander;
import com.aspectran.daemon.service.DaemonService;
import com.aspectran.daemon.service.DefaultDaemonService;
import com.aspectran.daemon.service.DefaultDaemonServiceBuilder;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.apon.AponReader;
import java.io.File;

public class AbstractDaemon
implements Daemon {
    private String name;
    private DefaultDaemonService daemonService;
    private CommandExecutor commandExecutor;
    private FileCommander fileCommander;
    private CommandRegistry commandRegistry;
    private boolean waiting;
    private Thread thread;
    private volatile boolean active;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getBasePath() {
        return this.daemonService != null ? this.daemonService.getBasePath() : null;
    }

    @Override
    public DaemonService getDaemonService() {
        return this.daemonService;
    }

    @Override
    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public FileCommander getFileCommander() {
        return this.fileCommander;
    }

    @Override
    public CommandRegistry getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public boolean isWaiting() {
        return this.waiting;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected void prepare(@Nullable String basePath, @Nullable File aspectranConfigFile) throws Exception {
        AspectranConfig aspectranConfig = new AspectranConfig();
        if (aspectranConfigFile != null) {
            try {
                AponReader.read(aspectranConfigFile, aspectranConfig);
            }
            catch (AponParseException e) {
                throw new IllegalArgumentException("Failed to parse aspectran config file: " + String.valueOf(aspectranConfigFile), e);
            }
        }
        this.prepare(basePath, aspectranConfig);
    }

    protected void prepare(@Nullable String basePath, @NonNull AspectranConfig aspectranConfig) throws Exception {
        if (StringUtils.hasText(basePath)) {
            aspectranConfig.touchContextConfig().setBasePath(basePath);
        }
        this.startDaemonService(aspectranConfig);
        this.initDaemon(aspectranConfig.touchDaemonConfig());
    }

    private void initDaemon(DaemonConfig daemonConfig) throws Exception {
        Aspectran.printPrettyAboutMe(System.out);
        try {
            DaemonExecutorConfig executorConfig = daemonConfig.touchExecutorConfig();
            this.commandExecutor = new CommandExecutor(this, executorConfig);
            DaemonPollingConfig pollingConfig = daemonConfig.touchPollingConfig();
            this.fileCommander = new DefaultFileCommander(this, pollingConfig);
            DaemonCommandRegistry commandRegistry = new DaemonCommandRegistry(this);
            commandRegistry.addCommand(daemonConfig.getCommands());
            if (commandRegistry.getCommand(QuitCommand.class) == null) {
                commandRegistry.addCommand(QuitCommand.class);
            }
            this.commandRegistry = commandRegistry;
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize daemon", e);
        }
    }

    private void startDaemonService(AspectranConfig aspectranConfig) throws Exception {
        try {
            this.daemonService = DefaultDaemonServiceBuilder.build(aspectranConfig);
            this.daemonService.start();
        }
        catch (Exception e) {
            throw new Exception("Failed to start daemon service", e);
        }
    }

    protected void start() throws Exception {
        this.start(false);
    }

    protected void start(boolean wait) throws Exception {
        if (wait) {
            this.start(0L);
        } else {
            this.start(-1L);
        }
    }

    protected void start(long waitTimeoutMillis) throws Exception {
        if (!this.active) {
            boolean bl = this.waiting = waitTimeoutMillis >= 0L;
            if (this.name == null) {
                this.name = this.getClass().getSimpleName();
            }
            Runnable runnable = () -> {
                if (!this.active) {
                    this.active = true;
                    if (this.fileCommander != null) {
                        this.fileCommander.requeue();
                        while (this.active) {
                            try {
                                if (this.fileCommander == null) continue;
                                this.fileCommander.polling();
                                Thread.sleep(this.fileCommander.getPollingInterval());
                            }
                            catch (InterruptedException ie) {
                                this.active = false;
                            }
                        }
                    }
                }
            };
            this.thread = new Thread(runnable, this.name);
            this.thread.start();
            if (waitTimeoutMillis >= 0L) {
                this.thread.join(waitTimeoutMillis);
            }
        }
    }

    @Override
    public void stop() {
        if (this.active) {
            this.active = false;
            if (this.thread != null) {
                if (this.thread.getState() == Thread.State.TIMED_WAITING) {
                    this.thread.interrupt();
                }
                this.thread = null;
            }
        }
    }

    @Override
    public void destroy() {
        this.stop();
        if (this.commandExecutor != null) {
            this.commandExecutor.shutdown();
        }
        if (this.fileCommander != null) {
            this.fileCommander = null;
        }
        if (this.daemonService != null) {
            this.daemonService.stop();
            this.daemonService = null;
        }
    }
}

