/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.daemon.DefaultDaemon;
import java.io.File;
import org.apache.commons.daemon.Daemon;
import org.apache.commons.daemon.DaemonContext;

public class JsvcDaemon
implements Daemon {
    private DefaultDaemon defaultDaemon;

    public void init(DaemonContext daemonContext) throws Exception {
        if (this.defaultDaemon == null) {
            String[] args = daemonContext.getArguments();
            String basePath = AspectranConfig.determineBasePath(args);
            File aspectranConfigFile = AspectranConfig.determineAspectranConfigFile(args);
            try {
                this.defaultDaemon = new DefaultDaemon();
                this.defaultDaemon.prepare(basePath, aspectranConfigFile);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.destroy();
                throw e;
            }
        }
    }

    public void start() throws Exception {
        if (this.defaultDaemon != null) {
            if (this.defaultDaemon.isActive()) {
                throw new Exception("Aspectran daemon is already running");
            }
            this.defaultDaemon.start();
        }
    }

    public void stop() throws Exception {
        if (this.defaultDaemon != null) {
            if (!this.defaultDaemon.isActive()) {
                throw new Exception("Aspectran daemon is not running, will do nothing");
            }
            this.defaultDaemon.stop();
        }
    }

    public void destroy() {
        if (this.defaultDaemon != null) {
            this.defaultDaemon.destroy();
            this.defaultDaemon = null;
        }
    }
}

