/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.daemon.DefaultDaemon;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.File;
import java.util.Arrays;

public class ProcrunDaemon {
    private static DefaultDaemon defaultDaemon;

    protected static DefaultDaemon getDefaultDaemon() {
        Assert.state(defaultDaemon != null, "No DefaultDaemon available");
        return defaultDaemon;
    }

    public static void start(String[] params) {
        Thread.currentThread().setName("procrun-start");
        ProcrunDaemon.start(params, 0L);
    }

    public static void stop(String[] args) {
        Thread.currentThread().setName("procrun-stop");
        ProcrunDaemon.stop();
    }

    protected static void start(String[] params, long waitTimeoutMillis) {
        if (defaultDaemon == null) {
            try {
                String basePath = AspectranConfig.determineBasePath(params);
                File aspectranConfigFile = AspectranConfig.determineAspectranConfigFile(params);
                defaultDaemon = new DefaultDaemon();
                defaultDaemon.prepare(basePath, aspectranConfigFile);
                defaultDaemon.start(waitTimeoutMillis);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                ProcrunDaemon.stop();
            }
        }
    }

    protected static void stop() {
        if (defaultDaemon != null) {
            try {
                defaultDaemon.destroy();
                defaultDaemon = null;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void main(@NonNull String[] args) {
        if (args.length > 0) {
            if ("start".equals(args[0])) {
                String[] params = Arrays.copyOfRange(args, 1, args.length);
                ProcrunDaemon.start(params);
            } else if ("stop".equals(args[0])) {
                ProcrunDaemon.stop();
            }
        }
    }
}

