/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command;

import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.service.DaemonService;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public abstract class AbstractCommand
implements Command {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CommandRegistry registry;
    private final boolean isolated;

    public AbstractCommand(CommandRegistry registry) {
        this(registry, false);
    }

    public AbstractCommand(CommandRegistry registry, boolean isolated) {
        this.registry = registry;
        this.isolated = isolated;
    }

    public CommandRegistry getCommandRegistry() {
        return this.registry;
    }

    @Override
    public boolean isIsolated() {
        return this.isolated;
    }

    public DaemonService getDaemonService() {
        DaemonService daemonService = this.registry.getDaemon().getDaemonService();
        if (daemonService == null || !daemonService.getServiceLifeCycle().isActive()) {
            throw new IllegalStateException("SERVICE NOT AVAILABLE");
        }
        return daemonService;
    }

    public boolean isServiceAvailable() {
        return this.registry.getDaemon().getDaemonService() != null && this.registry.getDaemon().getDaemonService().getServiceLifeCycle().isActive();
    }

    protected String debug(String message) {
        this.logger.debug(message);
        return message;
    }

    protected String info(String message) {
        this.logger.info(message);
        return message;
    }

    protected String warn(String message) {
        this.logger.warn(message);
        return message;
    }

    protected String error(String message) {
        this.logger.error(message);
        return message;
    }

    protected CommandResult success(String message) {
        return new CommandResult(true, message);
    }

    protected CommandResult failed(String message) {
        return new CommandResult(false, message);
    }

    protected CommandResult failed(String message, Throwable throwable) {
        this.logger.error(message, throwable);
        return new CommandResult(false, message + System.lineSeparator() + ExceptionUtils.getStacktrace(throwable));
    }

    protected CommandResult failed(Throwable throwable) {
        this.logger.error(throwable.toString(), throwable);
        return new CommandResult(false, ExceptionUtils.getStacktrace(throwable));
    }
}

