/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command;

import com.aspectran.core.context.config.DaemonExecutorConfig;
import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CommandExecutor.class);
    private static final int DEFAULT_MAX_THREADS = Runtime.getRuntime().availableProcessors();
    private final Daemon daemon;
    private final int maxThreads;
    private final ExecutorService executorService;
    private final AtomicInteger queueSize = new AtomicInteger();
    private final AtomicBoolean isolated = new AtomicBoolean();

    public CommandExecutor(Daemon daemon, DaemonExecutorConfig executorConfig) {
        if (daemon == null) {
            throw new IllegalArgumentException("daemon must not be null");
        }
        this.daemon = daemon;
        this.maxThreads = executorConfig != null ? executorConfig.getMaxThreads(DEFAULT_MAX_THREADS) : DEFAULT_MAX_THREADS;
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        this.executorService = new ThreadPoolExecutor(1, this.maxThreads, 180L, TimeUnit.SECONDS, workQueue);
    }

    public int getAvailableThreads() {
        return this.maxThreads - this.queueSize.get();
    }

    public boolean execute(CommandParameters parameters) {
        return this.execute(parameters, null);
    }

    public boolean execute(@NonNull CommandParameters parameters, Callback callback) {
        String commandName = parameters.getCommandName();
        if (this.isolated.get()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Holds '" + commandName + "' command until the end of the command requiring a single execution guarantee.");
            }
            return false;
        }
        Command command = this.daemon.getCommandRegistry().getCommand(commandName);
        if (command == null) {
            parameters.setResult("No command mapped to '" + commandName + "'");
            if (callback != null) {
                try {
                    callback.failure();
                }
                catch (Exception e) {
                    logger.error("Failed to execute callback", e);
                }
            }
            return false;
        }
        if (command.isIsolated() && this.queueSize.get() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("'" + commandName + "' command requires a single execution guarantee, so it is held until another command completes");
            }
            return false;
        }
        if (this.daemon.getDaemonService() != null) {
            parameters.setActivity(this.daemon.getDaemonService().getActivityContext().getAvailableActivity());
        }
        Runnable runnable = () -> {
            block7: {
                Thread currentThread = Thread.currentThread();
                String oldThreadName = currentThread.getName();
                try {
                    String threadName = "cmd-" + commandName + "-" + String.valueOf(this.queueSize);
                    currentThread.setName(threadName);
                    if (command.isIsolated()) {
                        this.isolated.set(true);
                    }
                    boolean success = this.execute(command, parameters);
                    if (callback == null) break block7;
                    try {
                        if (success) {
                            callback.success();
                            break block7;
                        }
                        callback.failure();
                    }
                    catch (Exception e) {
                        logger.error("Failed to execute callback", e);
                    }
                }
                finally {
                    currentThread.setName(oldThreadName);
                    this.isolated.compareAndSet(true, false);
                    this.queueSize.decrementAndGet();
                }
            }
        };
        this.queueSize.incrementAndGet();
        try {
            this.executorService.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            logger.error("Failed to execute command", e);
            this.queueSize.decrementAndGet();
            return false;
        }
    }

    private boolean execute(Command command, CommandParameters parameters) {
        try {
            CommandResult commandResult = command.execute(parameters);
            if (commandResult.isSuccess()) {
                parameters.setResult(commandResult.getResult());
                return true;
            }
            parameters.setResult("[FAILED] " + commandResult.getResult());
            return false;
        }
        catch (Exception e) {
            logger.error("Error executing daemon command " + String.valueOf(command), e);
            parameters.setResult("[FAILED] Error executing daemon command " + String.valueOf(command) + System.lineSeparator() + ExceptionUtils.getStacktrace(e));
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public void shutdown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface Callback {
        public void success();

        public void failure();
    }
}

