/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.asel.item.ItemEvaluator;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ItemRuleUtils;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.ItemHolderParameters;
import com.aspectran.core.context.rule.params.ItemParameters;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.ValueType;
import java.util.List;
import java.util.Map;

public class CommandParameters
extends AbstractParameters {
    private static final ParameterKey command = new ParameterKey("command", ValueType.STRING);
    private static final ParameterKey translet = new ParameterKey("translet", ValueType.STRING);
    private static final ParameterKey bean = new ParameterKey("bean", ValueType.STRING);
    private static final ParameterKey method = new ParameterKey("method", ValueType.STRING);
    private static final ParameterKey arguments = new ParameterKey("arguments", ItemHolderParameters.class);
    private static final ParameterKey properties = new ParameterKey("properties", ItemHolderParameters.class);
    private static final ParameterKey parameters = new ParameterKey("parameters", ItemHolderParameters.class);
    private static final ParameterKey attributes = new ParameterKey("attributes", ItemHolderParameters.class);
    private static final ParameterKey requeuable = new ParameterKey("requeuable", ValueType.BOOLEAN);
    private static final ParameterKey result = new ParameterKey("result", ValueType.TEXT);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{command, translet, bean, method, arguments, properties, parameters, attributes, requeuable, result};
    private Activity activity;

    public CommandParameters() {
        super(parameterKeys);
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public String getCommandName() {
        return this.getString(command);
    }

    public CommandParameters setCommandName(String commandName) {
        this.putValue(command, (Object)commandName);
        return this;
    }

    public String getTransletName() {
        return this.getString(translet);
    }

    public CommandParameters setTransletName(String transletName) {
        this.putValue(translet, (Object)transletName);
        return this;
    }

    public String getBeanName() {
        return this.getString(bean);
    }

    public CommandParameters setBeanName(String beanName) {
        this.putValue(bean, (Object)beanName);
        return this;
    }

    public String getMethodName() {
        return this.getString(method);
    }

    public CommandParameters setMethodName(String methodName) {
        this.putValue(method, (Object)methodName);
        return this;
    }

    public ItemRuleMap getArgumentItemRuleMap() throws IllegalRuleException {
        ItemHolderParameters itemHolderParameters = (ItemHolderParameters)this.getParameters(arguments);
        if (itemHolderParameters != null) {
            List<ItemParameters> itemParametersList = itemHolderParameters.getItemParametersList();
            return ItemRuleUtils.toItemRuleMap(itemParametersList);
        }
        return null;
    }

    public ItemRuleList getArgumentItemRuleList() throws IllegalRuleException {
        ItemHolderParameters itemHolderParameters = (ItemHolderParameters)this.getParameters(arguments);
        if (itemHolderParameters != null) {
            List<ItemParameters> itemParametersList = itemHolderParameters.getItemParametersList();
            return ItemRuleUtils.toItemRuleList(itemParametersList);
        }
        return null;
    }

    public Object[] getArguments() throws IllegalRuleException {
        if (this.activity == null) {
            throw new IllegalStateException("No available activity");
        }
        ItemRuleList itemRuleList = this.getArgumentItemRuleList();
        if (itemRuleList != null) {
            ItemEvaluator evaluator = this.activity.getItemEvaluator();
            Object[] args = new Object[itemRuleList.size()];
            for (int i = 0; i < itemRuleList.size(); ++i) {
                args[i] = evaluator.evaluate((ItemRule)itemRuleList.get(i));
            }
            return args;
        }
        return null;
    }

    public void putArgument(ItemRule itemRule) {
        ItemHolderParameters ihp = (ItemHolderParameters)this.touchParameters(arguments);
        ihp.addItemParameters(RulesToParameters.toItemParameters(itemRule));
        this.putValue(arguments, (Object)ihp);
    }

    public ItemRuleMap getPropertyItemRuleMap() throws IllegalRuleException {
        ItemHolderParameters itemHolderParameters = (ItemHolderParameters)this.getParameters(properties);
        if (itemHolderParameters != null) {
            List<ItemParameters> itemParametersList = itemHolderParameters.getItemParametersList();
            return ItemRuleUtils.toItemRuleMap(itemParametersList);
        }
        return null;
    }

    public ItemRuleMap getParameterItemRuleMap() throws IllegalRuleException {
        ItemHolderParameters itemHolderParameters = (ItemHolderParameters)this.getParameters(parameters);
        if (itemHolderParameters != null) {
            List<ItemParameters> itemParametersList = itemHolderParameters.getItemParametersList();
            return ItemRuleUtils.toItemRuleMap(itemParametersList);
        }
        return null;
    }

    public ParameterMap getParameterMap() throws IllegalRuleException {
        if (this.activity == null) {
            throw new IllegalStateException("No available activity");
        }
        ItemRuleMap parameterItemRuleMap = this.getParameterItemRuleMap();
        if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
            ItemEvaluator evaluator = this.activity.getItemEvaluator();
            return evaluator.evaluateAsParameterMap(parameterItemRuleMap);
        }
        return null;
    }

    public ItemRuleMap getAttributeItemRuleMap() throws IllegalRuleException {
        ItemHolderParameters itemHolderParameters = (ItemHolderParameters)this.getParameters(attributes);
        if (itemHolderParameters != null) {
            List<ItemParameters> itemParametersList = itemHolderParameters.getItemParametersList();
            return ItemRuleUtils.toItemRuleMap(itemParametersList);
        }
        return null;
    }

    public Map<String, Object> getAttributeMap() throws IllegalRuleException {
        if (this.activity == null) {
            throw new IllegalStateException("No available activity");
        }
        ItemRuleMap attributeItemRuleMap = this.getAttributeItemRuleMap();
        if (attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
            ItemEvaluator evaluator = this.activity.getItemEvaluator();
            return evaluator.evaluate(attributeItemRuleMap);
        }
        return null;
    }

    public boolean isRequeuable() {
        if (this.hasValue(requeuable)) {
            return this.getBoolean(requeuable, false);
        }
        return true;
    }

    public CommandParameters setRequeuable(boolean requeuable) {
        this.putValue(CommandParameters.requeuable, (Object)requeuable);
        return this;
    }

    public String getResult() {
        return this.getString(result);
    }

    public CommandParameters setResult(String resultText) {
        this.putValue(result, (Object)resultText);
        return this;
    }
}

