/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command;

import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.utils.ClassUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DaemonCommandRegistry
implements CommandRegistry {
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private final Daemon daemon;

    public DaemonCommandRegistry(Daemon daemon) {
        this.daemon = daemon;
    }

    @Override
    public Daemon getDaemon() {
        return this.daemon;
    }

    @Override
    public Command getCommand(String commandName) {
        return this.commands.get(commandName);
    }

    @Override
    public Command getCommand(Class<? extends Command> commandClass) {
        for (Command command : this.commands.values()) {
            if (!command.getClass().equals(commandClass)) continue;
            return command;
        }
        return null;
    }

    @Override
    public Collection<Command> getAllCommands() {
        return this.commands.values();
    }

    public void addCommand(String ... classNames) {
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    ClassLoader classLoader = ClassUtils.getDefaultClassLoader();
                    Class<?> commandClass = classLoader.loadClass(className);
                    this.addCommand(commandClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to load Command class: " + className, e);
                }
            }
        }
    }

    public void addCommand(Class<? extends Command> commandClass) {
        Object[] args = new Object[]{this};
        Class[] argTypes = new Class[]{CommandRegistry.class};
        Command command = ClassUtils.createInstance(commandClass, args, argTypes);
        if (command.getDescriptor() == null) {
            throw new NullPointerException("A command without a descriptor");
        }
        this.commands.put(command.getDescriptor().getName(), command);
    }
}

