/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.service.DaemonService;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.AponFormat;
import com.aspectran.utils.apon.AponWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.Set;

public class ComponentCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "component";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public ComponentCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        DaemonService daemonService = this.getDaemonService();
        try {
            ParameterMap parameterMap = parameters.getParameterMap();
            if (parameterMap == null) {
                return this.failed(this.error("No parameters specified"));
            }
            String type = parameterMap.getParameter("type");
            String mode = parameterMap.getParameter("mode");
            String[] targets = parameterMap.getParameterValues("targets");
            if (!StringUtils.hasLength(type)) {
                return this.failed(this.error("Component type is not specified"));
            }
            switch (type) {
                case "aspect": {
                    switch (mode) {
                        case "list": {
                            return this.listAspects(daemonService, targets);
                        }
                        case "detail": {
                            return this.describeAspectRule(daemonService, targets);
                        }
                        case "enable": {
                            return this.changeAspectActiveState(daemonService, targets, false);
                        }
                        case "disable": {
                            return this.changeAspectActiveState(daemonService, targets, true);
                        }
                    }
                    break;
                }
                case "translet": {
                    switch (mode) {
                        case "list": {
                            return this.listTranslets(daemonService, targets, false);
                        }
                        case "list-all": {
                            return this.listTranslets(daemonService, targets, true);
                        }
                        case "detail": {
                            return this.describeTransletRule(daemonService, targets, false);
                        }
                        case "detail-all": {
                            return this.describeTransletRule(daemonService, targets, true);
                        }
                    }
                    break;
                }
                case "job": {
                    switch (mode) {
                        case "list": {
                            return this.listScheduledJobs(daemonService, targets);
                        }
                        case "detail": {
                            return this.describeScheduledJobRule(daemonService, targets);
                        }
                        case "enable": {
                            return this.changeJobActiveState(daemonService, targets, false);
                        }
                        case "disable": {
                            return this.changeJobActiveState(daemonService, targets, true);
                        }
                    }
                    break;
                }
                default: {
                    return this.failed(this.error("Unknown component type: " + type));
                }
            }
            return this.failed(this.error("Unknown mode: " + type));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    private CommandResult listAspects(@NonNull DaemonService daemonService, String[] keywords) {
        AspectRuleRegistry aspectRuleRegistry = daemonService.getActivityContext().getAspectRuleRegistry();
        Collection<AspectRule> aspectRules = aspectRuleRegistry.getAspectRules();
        Formatter formatter = new Formatter();
        formatter.format("-%4s-+-%-45s-+-%-8s-+-%-8s-%n", "----", "---------------------------------------------", "--------", "--------");
        formatter.format(" %4s | %-45s | %-8s | %-8s %n", "No.", "Aspect ID", "Isolated", "Enabled");
        formatter.format("-%4s-+-%-45s-+-%-8s-+-%-8s-%n", "----", "---------------------------------------------", "--------", "--------");
        int num = 0;
        for (AspectRule aspectRule : aspectRules) {
            if (keywords != null) {
                boolean exists = false;
                for (String keyw : keywords) {
                    if (!aspectRule.getId().toLowerCase().contains(keyw.toLowerCase())) continue;
                    exists = true;
                    break;
                }
                if (!exists) continue;
            }
            formatter.format("%5d | %-45s | %-8s | %-8s %n", ++num, aspectRule.getId(), aspectRule.isIsolated(), !aspectRule.isDisabled());
        }
        if (num == 0) {
            formatter.format("%33s %s%n", " ", "No Data");
        }
        formatter.format("-%4s-+-%-45s-+-%-8s-+-%-8s-", "----", "---------------------------------------------", "--------", "--------");
        return this.success(formatter.toString());
    }

    private CommandResult describeAspectRule(@NonNull DaemonService daemonService, String[] targets) throws IOException {
        Collection<AspectRule> aspectRules;
        AspectRuleRegistry aspectRuleRegistry = daemonService.getActivityContext().getAspectRuleRegistry();
        if (targets == null || targets.length == 0) {
            aspectRules = aspectRuleRegistry.getAspectRules();
        } else {
            aspectRules = new LinkedHashSet<AspectRule>();
            for (String aspectId : targets) {
                AspectRule aspectRule = aspectRuleRegistry.getAspectRule(aspectId);
                if (aspectRule == null) {
                    return this.failed(this.error("Unknown aspect: " + aspectId));
                }
                aspectRules.add(aspectRule);
            }
        }
        int count = 0;
        StringWriter writer = new StringWriter();
        for (AspectRule aspectRule : aspectRules) {
            AspectParameters aspectParameters = RulesToParameters.toAspectParameters(aspectRule);
            if (count > 0) {
                writer.write("----------------------------------------------------------------------------");
                writer.write(AponFormat.SYSTEM_NEW_LINE);
            }
            Object aponWriter = new AponWriter(writer).nullWritable(false);
            ((AponWriter)aponWriter).write(aspectParameters);
            ++count;
        }
        if (count == 0) {
            return this.success("No aspects");
        }
        return this.success(writer.toString().trim());
    }

    private CommandResult changeAspectActiveState(DaemonService daemonService, String[] targets, boolean disabled) {
        if (targets == null || targets.length == 0) {
            return this.failed(this.error("Please specify aspects to be enabled or disabled"));
        }
        AspectRuleRegistry aspectRuleRegistry = daemonService.getActivityContext().getAspectRuleRegistry();
        LinkedHashSet<AspectRule> aspectRules = new LinkedHashSet<AspectRule>();
        for (String aspectId : targets) {
            AspectRule aspectRule = aspectRuleRegistry.getAspectRule(aspectId);
            if (aspectRule == null) {
                return this.failed(this.error("Unknown aspect: " + aspectId));
            }
            if (aspectRule.isIsolated()) {
                return this.failed(this.error("Can not be disabled or enabled for isolated Aspect '" + aspectId + "'"));
            }
            aspectRules.add(aspectRule);
        }
        Formatter formatter = new Formatter();
        for (AspectRule aspectRule : aspectRules) {
            if (disabled) {
                if (aspectRule.isDisabled()) {
                    formatter.format("Aspect '%s' is already inactive%n", aspectRule.getId());
                    continue;
                }
                aspectRule.setDisabled(true);
                formatter.format("Aspect '%s' is now inactive%n", aspectRule.getId());
                continue;
            }
            if (!aspectRule.isDisabled()) {
                formatter.format("Aspect '%s' is already active%n", aspectRule.getId());
                continue;
            }
            aspectRule.setDisabled(false);
            formatter.format("Aspect '%s' is now active%n", aspectRule.getId());
        }
        return this.success(formatter.toString());
    }

    private CommandResult listTranslets(@NonNull DaemonService daemonService, String[] keywords, boolean all) {
        TransletRuleRegistry transletRuleRegistry = daemonService.getActivityContext().getTransletRuleRegistry();
        Collection<TransletRule> transletRules = transletRuleRegistry.getTransletRules();
        Formatter formatter = new Formatter();
        formatter.format("-%4s-+-%-67s-%n", "----", "-------------------------------------------------------------------");
        formatter.format(" %4s | %-67s %n", "No.", "Translet Name");
        formatter.format("-%4s-+-%-67s-%n", "----", "-------------------------------------------------------------------");
        int num = 0;
        for (TransletRule transletRule : transletRules) {
            MethodType[] requestMethods;
            Object transletName = transletRule.getName();
            if (!all && !daemonService.isAcceptable((String)transletName)) continue;
            if (keywords != null) {
                boolean exists = false;
                for (String kw : keywords) {
                    if (!((String)transletName).toLowerCase().contains(kw.toLowerCase())) continue;
                    exists = true;
                    break;
                }
                if (!exists) continue;
            }
            if ((requestMethods = transletRule.getAllowedMethods()) != null) {
                transletName = StringUtils.toDelimitedString((Object[])requestMethods, ",") + " " + (String)transletName;
            }
            formatter.format("%5d | %s%n", ++num, transletName);
        }
        if (num == 0) {
            formatter.format("%33s %s%n", " ", "No Data");
        }
        formatter.format("-%4s-+-%-67s-", "----", "-------------------------------------------------------------------");
        return this.success(formatter.toString());
    }

    private CommandResult describeTransletRule(@NonNull DaemonService daemonService, String[] targets, boolean all) throws IOException {
        Collection<TransletRule> transletRules;
        TransletRuleRegistry transletRuleRegistry = daemonService.getActivityContext().getTransletRuleRegistry();
        if (targets == null || targets.length == 0) {
            transletRules = transletRuleRegistry.getTransletRules();
        } else {
            transletRules = new LinkedHashSet<TransletRule>();
            for (String transletName : targets) {
                TransletRule transletRule;
                MethodType requestMethod = null;
                for (MethodType methodType : MethodType.values()) {
                    if (!transletName.startsWith(methodType.name() + " ")) continue;
                    transletName = transletName.substring(methodType.name().length() + 1).trim();
                    requestMethod = methodType;
                    break;
                }
                if ((transletRule = requestMethod != null ? transletRuleRegistry.getTransletRule(transletName, requestMethod) : transletRuleRegistry.getTransletRule(transletName)) == null) {
                    return this.failed(this.error("Unknown translet: " + targets[0]));
                }
                transletRules.add(transletRule);
            }
        }
        int count = 0;
        StringWriter writer = new StringWriter();
        for (TransletRule transletRule : transletRules) {
            if (!all && !daemonService.isAcceptable(transletRule.getName())) continue;
            TransletParameters transletParameters = RulesToParameters.toTransletParameters(transletRule);
            if (count > 0) {
                writer.write("----------------------------------------------------------------------------");
                writer.write(AponFormat.SYSTEM_NEW_LINE);
            }
            Object aponWriter = new AponWriter(writer).nullWritable(false);
            ((AponWriter)aponWriter).write(transletParameters);
            ++count;
        }
        if (count == 0) {
            return this.success("No translets");
        }
        return this.success(writer.toString().trim());
    }

    private CommandResult listScheduledJobs(@NonNull DaemonService daemonService, String[] keywords) {
        Collection<ScheduleRule> scheduleRules = daemonService.getActivityContext().getScheduleRuleRegistry().getScheduleRules();
        Formatter formatter = new Formatter();
        formatter.format("-%4s-+-%-20s-+-%-33s-+-%-8s-%n", "----", "--------------------", "---------------------------------", "--------");
        formatter.format(" %4s | %-20s | %-33s | %-8s %n", "No.", "Schedule ID", "Job Name", "Enabled");
        formatter.format("-%4s-+-%-20s-+-%-33s-+-%-8s-%n", "----", "--------------------", "---------------------------------", "--------");
        int num = 0;
        for (ScheduleRule scheduleRule : scheduleRules) {
            for (ScheduledJobRule jobRule : scheduleRule.getScheduledJobRuleList()) {
                if (keywords != null) {
                    boolean exists = false;
                    for (String keyw : keywords) {
                        if (!jobRule.getTransletName().toLowerCase().contains(keyw.toLowerCase())) continue;
                        exists = true;
                        break;
                    }
                    if (!exists) continue;
                }
                formatter.format("%5d | %-20s | %-33s | %-8s %n", ++num, scheduleRule.getId(), jobRule.getTransletName(), !jobRule.isDisabled());
            }
        }
        if (num == 0) {
            formatter.format("%33s %s%n", " ", "No Data");
        }
        formatter.format("-%4s-+-%-20s-+-%-33s-+-%-8s-", "----", "--------------------", "---------------------------------", "--------");
        return this.success(formatter.toString());
    }

    private CommandResult describeScheduledJobRule(@NonNull DaemonService daemonService, String[] targets) throws IOException {
        ScheduleRuleRegistry scheduleRuleRegistry = daemonService.getActivityContext().getScheduleRuleRegistry();
        if (targets == null || targets.length == 0) {
            StringWriter writer = new StringWriter();
            int count = 0;
            for (ScheduleRule scheduleRule : scheduleRuleRegistry.getScheduleRules()) {
                ScheduleParameters scheduleParameters = RulesToParameters.toScheduleParameters(scheduleRule);
                if (count > 0) {
                    ((Writer)writer).write("----------------------------------------------------------------------------");
                    ((Writer)writer).write(AponFormat.SYSTEM_NEW_LINE);
                }
                Object aponWriter = new AponWriter(writer).nullWritable(false);
                ((AponWriter)aponWriter).write(scheduleParameters);
                ++count;
            }
            if (count == 0) {
                return this.success("No scheduled jobs");
            }
            return this.success(((Object)writer).toString().trim());
        }
        LinkedHashSet<String> transletNames = new LinkedHashSet<String>();
        for (ScheduleRule scheduleRule : scheduleRuleRegistry.getScheduleRules()) {
            for (ScheduledJobRule jobRule : scheduleRule.getScheduledJobRuleList()) {
                for (String string : targets) {
                    if (!jobRule.getTransletName().equals(string)) continue;
                    transletNames.add(jobRule.getTransletName());
                }
            }
        }
        if (transletNames.isEmpty()) {
            return this.failed(this.error("Unknown scheduled jobs " + Arrays.toString(targets)));
        }
        int count = 0;
        StringWriter writer = new StringWriter();
        for (ScheduleRule scheduleRule : scheduleRuleRegistry.getScheduleRules()) {
            for (ScheduledJobRule jobRule : scheduleRule.getScheduledJobRuleList()) {
                for (String string : transletNames) {
                    if (!jobRule.getTransletName().equals(string)) continue;
                    ScheduleParameters scheduleParameters = RulesToParameters.toScheduleParameters(jobRule.getScheduleRule(), jobRule);
                    if (count > 0) {
                        ((Writer)writer).write("----------------------------------------------------------------------------");
                        ((Writer)writer).write(AponFormat.SYSTEM_NEW_LINE);
                    }
                    Object aponWriter = new AponWriter(writer).nullWritable(false);
                    ((AponWriter)aponWriter).write(scheduleParameters);
                    ++count;
                }
            }
        }
        return this.success(((Object)writer).toString().trim());
    }

    private CommandResult changeJobActiveState(DaemonService daemonService, String[] targets, boolean disabled) {
        if (targets == null || targets.length == 0) {
            return this.failed(this.error("Please specify jobs to be enabled or disabled"));
        }
        ScheduleRuleRegistry scheduleRuleRegistry = daemonService.getActivityContext().getScheduleRuleRegistry();
        Set<ScheduledJobRule> scheduledJobRules = scheduleRuleRegistry.getScheduledJobRules(targets);
        if (scheduledJobRules.isEmpty()) {
            return this.failed(this.error("Unknown scheduled jobs " + Arrays.toString(targets)));
        }
        Formatter formatter = new Formatter();
        for (ScheduledJobRule jobRule : scheduledJobRules) {
            if (disabled) {
                if (jobRule.isDisabled()) {
                    formatter.format("Scheduled job '%s' on schedule '%s' is already inactive", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                    continue;
                }
                jobRule.setDisabled(true);
                formatter.format("Scheduled job '%s' on schedule '%s' is now inactive", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                continue;
            }
            if (!jobRule.isDisabled()) {
                formatter.format("Scheduled job '%s' on schedule '%s' is already active", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
                continue;
            }
            jobRule.setDisabled(false);
            formatter.format("Scheduled job '%s' on schedule '%s' is now active", jobRule.getTransletName(), jobRule.getScheduleRule().getId());
        }
        return this.success(formatter.toString());
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return ComponentCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return ComponentCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Display detailed information about aspect, translet, or scheduled job and control its active state";
        }
    }
}

