/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class PollingIntervalCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "pollingInterval";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public PollingIntervalCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        try {
            long oldPollingInterval = this.getCommandRegistry().getDaemon().getFileCommander().getPollingInterval();
            long newPollingInterval = 0L;
            Object[] args = parameters.getArguments();
            if (args != null && args.length > 0) {
                newPollingInterval = args[0] instanceof Long ? (Long)args[0] : Long.parseLong(args[0].toString());
            }
            if (newPollingInterval == 0L) {
                return this.failed(this.warn("The polling interval does not change"));
            }
            if (newPollingInterval < 0L) {
                return this.failed(this.error("The polling interval can not be negative: " + newPollingInterval));
            }
            if (newPollingInterval < 1000L) {
                return this.failed(this.error("The polling interval must be greater than 1000 ms."));
            }
            this.getCommandRegistry().getDaemon().getFileCommander().setPollingInterval(newPollingInterval);
            return this.success(this.info("The polling interval is changed from " + oldPollingInterval + "ms to " + newPollingInterval + " ms"));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return PollingIntervalCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return PollingIntervalCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Specifies in seconds how often the daemon polls for new commands";
        }
    }
}

