/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class QuitCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "quit";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public QuitCommand(CommandRegistry registry) {
        super(registry, true);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        if (!this.getCommandRegistry().getDaemon().isWaiting()) {
            return this.failed(this.getCommandRegistry().getDaemon().getName() + " does not support the quit command");
        }
        this.info("Shutting down the " + this.getCommandRegistry().getDaemon().getName());
        this.getCommandRegistry().getDaemon().stop();
        return this.success(this.info("Goodbye."));
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return QuitCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return QuitCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Releases all resources and exits this daemon";
        }
    }
}

