/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.service.DaemonService;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class RestartCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "restart";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public RestartCommand(CommandRegistry registry) {
        super(registry, true);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        DaemonService daemonService = this.getDaemonService();
        try {
            this.info("Restarting Now. See you soon.");
            daemonService.getServiceLifeCycle().restart();
            return this.success(this.info("Successful restart command"));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return RestartCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return RestartCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Restart the daemon to reload all resources";
        }
    }
}

