/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.core.context.resource.SiblingClassLoader;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;

public class SysInfoCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "sysinfo";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public SysInfoCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        try {
            Object[] args = parameters.getArguments();
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            HashSet<Object> done = new HashSet<Object>();
            if (args != null) {
                for (Object arg : args) {
                    if (!done.contains(arg)) {
                        if (!done.isEmpty()) {
                            printWriter.println();
                        }
                        if ("props".equals(arg)) {
                            this.printSysProperties(printWriter);
                        } else if ("cp".equals(arg)) {
                            this.printClasspath(printWriter);
                        } else if ("mem".equals(arg)) {
                            this.mem(false, printWriter);
                        } else if ("gc".equals(arg)) {
                            this.mem(true, printWriter);
                        }
                    }
                    done.add(arg);
                }
            }
            return this.success(((Object)writer).toString());
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    private void printSysProperties(@NonNull PrintWriter printWriter) {
        printWriter.println("---------------------");
        printWriter.println("JVM system properties");
        printWriter.println("---------------------");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String value = entry.getValue() != null ? this.escape(entry.getValue().toString()) : null;
            printWriter.format("%s=%s", entry.getKey(), StringUtils.nullToEmpty(value)).println();
        }
    }

    private void printClasspath(@NonNull PrintWriter printWriter) {
        ClassLoader classLoader;
        printWriter.println("-------------------------");
        printWriter.println("JVM classpath information");
        printWriter.println("-------------------------");
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        for (String line : StringUtils.split(bean.getClassPath(), File.pathSeparator)) {
            printWriter.println(line);
        }
        if (this.isServiceAvailable() && (classLoader = this.getDaemonService().getServiceClassLoader()) instanceof SiblingClassLoader) {
            SiblingClassLoader scl = (SiblingClassLoader)classLoader;
            Enumeration<URL> urls = scl.getAllResources();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                printWriter.println(url.toString());
            }
        }
    }

    private void mem(boolean gc, @NonNull PrintWriter printWriter) {
        long max = Runtime.getRuntime().maxMemory();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        printWriter.println("------------------------------------");
        printWriter.println("Memory information about current JVM");
        printWriter.println("------------------------------------");
        printWriter.format("%-23s %12s", "Available memory", StringUtils.toHumanFriendlyByteSize(max)).println();
        printWriter.format("%-23s %12s", "Total memory", StringUtils.toHumanFriendlyByteSize(total)).println();
        printWriter.format("%-23s %12s", "Used memory", StringUtils.toHumanFriendlyByteSize(total - free)).println();
        printWriter.format("%-23s %12s", "Free memory before GC", StringUtils.toHumanFriendlyByteSize(free)).println();
        if (gc) {
            System.gc();
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long after = Runtime.getRuntime().freeMemory();
            printWriter.format("%-23s %12s", "Free memory after GC", StringUtils.toHumanFriendlyByteSize(after)).println();
            printWriter.format("%-23s %12s", "Memory gained with GC", StringUtils.toHumanFriendlyByteSize(after - free)).println();
        } else {
            printWriter.format("%-23s %12s", "Free memory", StringUtils.toHumanFriendlyByteSize(free)).println();
        }
        printWriter.println("------------------------------------");
    }

    @NonNull
    private String escape(@NonNull String s) {
        return s.replace("\t", "\\t").replace("\b", "\\b").replace("\n", "\\n").replace("\r", "\\r").replace("\f", "\\f");
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return SysInfoCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return SysInfoCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Prints current JVM runtime information";
        }
    }
}

