/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.builtins;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.daemon.service.DaemonService;
import com.aspectran.utils.OutputStringWriter;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.Writer;
import java.util.Map;

public class TransletCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "translet";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public TransletCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(@NonNull CommandParameters parameters) {
        DaemonService daemonService = this.getDaemonService();
        String transletName = parameters.getTransletName();
        if (transletName == null) {
            return this.failed(this.error("'translet' parameter is not specified"));
        }
        try {
            OutputStringWriter stringWriter;
            Map<String, Object> attributeMap = parameters.getAttributeMap();
            ParameterMap parameterMap = parameters.getParameterMap();
            Translet translet = daemonService.translate(transletName, attributeMap, parameterMap);
            Writer writer = translet.getResponseAdapter().getWriter();
            if (writer instanceof OutputStringWriter && !(stringWriter = (OutputStringWriter)writer).isDirty()) {
                return this.success(null);
            }
            return this.success(writer.toString());
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return TransletCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return TransletCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Executes a translet";
        }
    }
}

