/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.polling;

import com.aspectran.core.context.config.DaemonPollingConfig;
import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.CommandExecutor;
import com.aspectran.daemon.command.polling.FileCommander;

public abstract class AbstractFileCommander
implements FileCommander {
    private static final long DEFAULT_POLLING_INTERVAL = 5000L;
    private final Daemon daemon;
    private volatile long pollingInterval;
    private final boolean requeuable;

    public AbstractFileCommander(Daemon daemon, DaemonPollingConfig pollingConfig) {
        if (daemon == null) {
            throw new IllegalArgumentException("daemon must not be null");
        }
        this.daemon = daemon;
        this.pollingInterval = pollingConfig.getPollingInterval(5000L);
        this.requeuable = pollingConfig.isRequeuable();
    }

    @Override
    public Daemon getDaemon() {
        return this.daemon;
    }

    @Override
    public CommandExecutor getCommandExecutor() {
        return this.daemon.getCommandExecutor();
    }

    @Override
    public long getPollingInterval() {
        return this.pollingInterval;
    }

    @Override
    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    @Override
    public boolean isRequeuable() {
        return this.requeuable;
    }
}

