/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.command.polling;

import com.aspectran.core.context.config.DaemonPollingConfig;
import com.aspectran.daemon.Daemon;
import com.aspectran.daemon.command.CommandExecutor;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.polling.AbstractFileCommander;
import com.aspectran.utils.FilenameUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponReader;
import com.aspectran.utils.apon.AponWriter;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Comparator;

public class DefaultFileCommander
extends AbstractFileCommander {
    protected final Logger logger = LoggerFactory.getLogger(DefaultFileCommander.class);
    private static final String COMMANDS_PATH = "/cmd";
    private static final String QUEUED_PATH = "/cmd/queued";
    private static final String COMPLETED_PATH = "/cmd/completed";
    private static final String FAILED_PATH = "/cmd/failed";
    private static final String DEFAULT_INCOMING_PATH = "/cmd/incoming";
    private final Object lock = new Object();
    private final File incomingDir;
    private final File queuedDir;
    private final File completedDir;
    private final File failedDir;

    public DefaultFileCommander(Daemon daemon, DaemonPollingConfig pollingConfig) throws Exception {
        super(daemon, pollingConfig);
        try {
            File incomingDir;
            File commandsDir = new File(this.getDaemon().getBasePath(), COMMANDS_PATH);
            commandsDir.mkdirs();
            File queuedDir = new File(this.getDaemon().getBasePath(), QUEUED_PATH);
            queuedDir.mkdirs();
            this.queuedDir = queuedDir;
            File completedDir = new File(this.getDaemon().getBasePath(), COMPLETED_PATH);
            completedDir.mkdirs();
            this.completedDir = completedDir;
            File failedDir = new File(this.getDaemon().getBasePath(), FAILED_PATH);
            failedDir.mkdirs();
            this.failedDir = failedDir;
            String incomingPath = pollingConfig.getIncoming(DEFAULT_INCOMING_PATH);
            if (incomingPath.startsWith("file:")) {
                URI uri = URI.create(incomingPath);
                incomingDir = new File(uri);
            } else {
                incomingDir = new File(this.getDaemon().getBasePath(), incomingPath);
            }
            incomingDir.mkdirs();
            this.incomingDir = incomingDir;
            File[] incomingFiles = this.retrieveCommandFiles(incomingDir);
            if (incomingFiles != null) {
                for (File file : incomingFiles) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Delete old incoming command file: " + String.valueOf(file));
                    }
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Could not create directory structure for file commander", e);
        }
    }

    public File getIncomingDir() {
        return this.incomingDir;
    }

    public File getQueuedDir() {
        return this.queuedDir;
    }

    public File getCompletedDir() {
        return this.completedDir;
    }

    public File getFailedDir() {
        return this.failedDir;
    }

    @Override
    public void requeue() {
        block5: {
            File[] queuedFiles = this.retrieveCommandFiles(this.queuedDir);
            if (queuedFiles == null) break block5;
            if (this.isRequeuable()) {
                for (File file : queuedFiles) {
                    CommandParameters parameters = this.readCommandFile(file);
                    if (parameters == null) continue;
                    if (parameters.isRequeuable()) {
                        this.writeIncomingCommand(parameters, file.getName());
                    }
                    this.removeCommandFile(this.queuedDir, file.getName());
                }
            } else {
                for (File file : queuedFiles) {
                    this.removeCommandFile(this.queuedDir, file.getName());
                }
            }
        }
    }

    @Override
    public void polling() {
        File[] files = this.retrieveCommandFiles(this.incomingDir);
        if (files != null) {
            int limit = this.getCommandExecutor().getAvailableThreads();
            for (int i = 0; i < files.length && i < limit; ++i) {
                String incomingFileName;
                String queuedFileName;
                File file = files[i];
                CommandParameters parameters = this.readCommandFile(file);
                if (parameters == null || (queuedFileName = this.writeQueuedCommand(parameters, incomingFileName = file.getName())) == null) continue;
                this.removeCommandFile(this.incomingDir, incomingFileName);
                this.executeQueuedCommand(parameters, queuedFileName);
            }
        }
    }

    private void executeQueuedCommand(final CommandParameters parameters, final String fileName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute Command: " + fileName + System.lineSeparator() + String.valueOf(parameters));
        }
        this.getCommandExecutor().execute(parameters, new CommandExecutor.Callback(){

            @Override
            public void success() {
                DefaultFileCommander.this.removeCommandFile(DefaultFileCommander.this.queuedDir, fileName);
                DefaultFileCommander.this.writeCompletedCommand(parameters, this.makeFileName());
                if (DefaultFileCommander.this.logger.isTraceEnabled()) {
                    DefaultFileCommander.this.logger.trace("Result of Completed Command: " + fileName + System.lineSeparator() + String.valueOf(parameters));
                }
            }

            @Override
            public void failure() {
                DefaultFileCommander.this.removeCommandFile(DefaultFileCommander.this.queuedDir, fileName);
                DefaultFileCommander.this.writeFailedCommand(parameters, this.makeFileName());
                if (DefaultFileCommander.this.logger.isTraceEnabled()) {
                    DefaultFileCommander.this.logger.trace("Result of Failed Command: " + fileName + System.lineSeparator() + String.valueOf(parameters));
                }
            }

            @NonNull
            private String makeFileName() {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssSSS");
                String datetime = formatter.format(LocalDateTime.now());
                return datetime + "_" + fileName;
            }
        });
    }

    private File[] retrieveCommandFiles(@NonNull File dir) {
        File[] files = dir.listFiles(file -> file.isFile() && file.getName().toLowerCase().endsWith(".apon"));
        if (files != null && files.length > 0) {
            Arrays.sort(files, Comparator.comparing(File::getName));
        }
        return files;
    }

    @Nullable
    private CommandParameters readCommandFile(@NonNull File file) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Read command file: " + String.valueOf(file));
        }
        try {
            CommandParameters parameters = new CommandParameters();
            AponReader.read(file, parameters);
            return parameters;
        }
        catch (Exception e) {
            this.logger.error("Failed to read command file: " + String.valueOf(file), e);
            this.removeCommandFile(this.incomingDir, file.getName());
            return null;
        }
    }

    private void writeIncomingCommand(CommandParameters parameters, String fileName) {
        String written = this.writeCommandFile(this.incomingDir, fileName, parameters);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Incoming Command: " + written + " in " + String.valueOf(this.incomingDir));
        }
    }

    private String writeQueuedCommand(CommandParameters parameters, String fileName) {
        String written = this.writeCommandFile(this.queuedDir, fileName, parameters);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Queued Command: " + written + " in " + String.valueOf(this.queuedDir));
        }
        return written;
    }

    private void writeCompletedCommand(CommandParameters parameters, String fileName) {
        String written = this.writeCommandFile(this.completedDir, fileName, parameters);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Completed Command: " + written + " in " + String.valueOf(this.completedDir));
        }
    }

    private void writeFailedCommand(CommandParameters parameters, String fileName) {
        String written = this.writeCommandFile(this.failedDir, fileName, parameters);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Failed Command: " + written + " in " + String.valueOf(this.failedDir));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String writeCommandFile(File dir, String fileName, CommandParameters parameters) {
        File file = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                file = FilenameUtils.generateUniqueFile(new File(dir, fileName));
                file.createNewFile();
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Write command file: " + String.valueOf(file));
            }
            Object aponWriter = new AponWriter(file).nullWritable(false);
            ((AponWriter)aponWriter).write(parameters);
            ((AponWriter)aponWriter).close();
            return file.getName();
        }
        catch (IOException e) {
            if (file != null) {
                this.logger.warn("Failed to write command file: " + String.valueOf(file), e);
            } else {
                File f = new File(dir, fileName);
                this.logger.warn("Failed to write command file: " + String.valueOf(f), e);
            }
            return null;
        }
    }

    private void removeCommandFile(File dir, String fileName) {
        File file = new File(dir, fileName);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Delete command file: " + String.valueOf(file));
        }
        if (!file.delete()) {
            this.logger.warn("Failed to delete command file: " + String.valueOf(file));
        }
    }
}

