/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.service;

import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.config.AcceptableConfig;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.core.service.DefaultCoreService;
import com.aspectran.core.service.RequestAcceptor;
import com.aspectran.daemon.adapter.DaemonSessionAdapter;
import com.aspectran.daemon.service.DaemonService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;

public abstract class AbstractDaemonService
extends DefaultCoreService
implements DaemonService {
    private SessionManager sessionManager;
    private SessionAgent sessionAgent;

    AbstractDaemonService() {
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        if (this.sessionAgent != null) {
            return new DaemonSessionAdapter(this.sessionAgent);
        }
        return null;
    }

    protected void createSessionManager() {
        SessionManagerConfig sessionManagerConfig;
        Assert.state(this.sessionManager == null, "Session Manager is already exists for daemon service");
        DaemonConfig daemonConfig = this.getAspectranConfig().getDaemonConfig();
        if (daemonConfig != null && (sessionManagerConfig = daemonConfig.getSessionManagerConfig()) != null && sessionManagerConfig.isEnabled()) {
            try {
                DefaultSessionManager sessionManager = new DefaultSessionManager();
                sessionManager.setActivityContext(this.getActivityContext());
                sessionManager.setSessionManagerConfig(sessionManagerConfig);
                sessionManager.initialize();
                this.sessionManager = sessionManager;
                this.sessionAgent = new SessionAgent(sessionManager.getSessionHandler());
            }
            catch (Exception e) {
                throw new CoreServiceException("Failed to create session manager for daemon service", e);
            }
        }
    }

    protected void destroySessionManager() {
        if (this.sessionAgent != null) {
            this.sessionAgent.invalidate();
            this.sessionAgent = null;
        }
        if (this.sessionManager != null) {
            this.sessionManager.destroy();
            this.sessionManager = null;
        }
    }

    @Override
    protected void configure(@NonNull AspectranConfig aspectranConfig) {
        DaemonConfig daemonConfig = aspectranConfig.getDaemonConfig();
        if (daemonConfig != null) {
            this.configure(daemonConfig);
        }
        super.configure(aspectranConfig);
    }

    private void configure(@NonNull DaemonConfig daemonConfig) {
        AcceptableConfig acceptableConfig = daemonConfig.getAcceptableConfig();
        if (acceptableConfig != null) {
            this.setRequestAcceptor(new RequestAcceptor(acceptableConfig));
        }
    }
}

