/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.CoreTranslet;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.daemon.activity.DaemonActivity;
import com.aspectran.daemon.service.AbstractDaemonService;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Map;

public class DefaultDaemonService
extends AbstractDaemonService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDaemonService.class);
    protected volatile long pauseTimeout = -1L;

    DefaultDaemonService() {
    }

    @Override
    public Translet translate(String name, Map<String, Object> attributeMap, ParameterMap parameterMap) {
        MethodType requestMethod = null;
        if (name != null) {
            for (MethodType methodType : MethodType.values()) {
                if (!name.startsWith(methodType.name() + " ")) continue;
                requestMethod = methodType;
                name = name.substring(methodType.name().length()).trim();
            }
        }
        return this.translate(name, requestMethod, attributeMap, parameterMap);
    }

    @Override
    public Translet translate(String name, MethodType method, Map<String, Object> attributeMap, ParameterMap parameterMap) {
        if (this.checkPaused(name)) {
            return null;
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (!this.isAcceptable(name)) {
            logger.error("Unavailable translet: " + name);
            return null;
        }
        DaemonActivity activity = new DaemonActivity(this);
        activity.setRequestName(name);
        activity.setRequestMethod(method != null ? method : MethodType.GET);
        activity.setAttributeMap(attributeMap);
        activity.setParameterMap(parameterMap);
        CoreTranslet translet = null;
        try {
            activity.prepare();
            activity.perform();
            translet = activity.getTranslet();
        }
        catch (ActivityTerminatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (Exception e) {
            Throwable t = activity.getRaisedException() != null ? activity.getRaisedException() : e;
            Throwable cause = ExceptionUtils.getRootCause(t);
            throw new CoreServiceException("Error occurred while processing request: " + activity.getFullRequestName() + "; Cause: " + ExceptionUtils.getSimpleMessage(cause), t);
        }
        return translet;
    }

    private boolean checkPaused(String name) {
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getServiceName() + " is paused, so did not execute translet: " + name);
                }
                return true;
            }
            this.pauseTimeout = 0L;
        }
        return false;
    }
}

