/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.daemon.service;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.service.CoreServiceHolder;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.daemon.service.DefaultDaemonService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public abstract class DefaultDaemonServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDaemonServiceBuilder.class);

    @NonNull
    public static DefaultDaemonService build(AspectranConfig aspectranConfig) {
        Assert.notNull((Object)aspectranConfig, "aspectranConfig must not be null");
        DefaultDaemonService daemonService = new DefaultDaemonService();
        daemonService.configure(aspectranConfig);
        DefaultDaemonServiceBuilder.setServiceStateListener(daemonService);
        return daemonService;
    }

    private static void setServiceStateListener(final @NonNull DefaultDaemonService daemonService) {
        daemonService.setServiceStateListener(new ServiceStateListener(){

            @Override
            public void started() {
                CoreServiceHolder.hold(daemonService);
                daemonService.createSessionManager();
                daemonService.pauseTimeout = 0L;
            }

            @Override
            public void stopped() {
                daemonService.destroySessionManager();
                CoreServiceHolder.release(daemonService);
            }

            @Override
            public void paused(long millis) {
                if (millis > 0L) {
                    daemonService.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            @Override
            public void paused() {
                daemonService.pauseTimeout = -1L;
            }

            @Override
            public void resumed() {
                daemonService.pauseTimeout = 0L;
            }
        });
    }
}

