/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.activity;

import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.adapter.DefaultSessionAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.embed.adapter.AspectranRequestAdapter;
import com.aspectran.embed.adapter.AspectranResponseAdapter;
import com.aspectran.embed.service.AbstractEmbeddedAspectran;
import com.aspectran.embed.service.EmbeddedAspectran;
import com.aspectran.utils.Assert;
import com.aspectran.utils.OutputStringWriter;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.Writer;
import java.util.Map;

public class AspectranActivity
extends CoreActivity {
    private final EmbeddedAspectran aspectran;
    private Writer outputWriter;
    private String requestName;
    private MethodType requestMethod;
    private Map<String, Object> attributeMap;
    private ParameterMap parameterMap;
    private String body;

    public AspectranActivity(AbstractEmbeddedAspectran aspectran) {
        this(aspectran, null);
    }

    public AspectranActivity(@NonNull AbstractEmbeddedAspectran aspectran, Writer outputWriter) {
        super(aspectran.getActivityContext());
        this.aspectran = aspectran;
        this.outputWriter = outputWriter;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(MethodType requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getFullRequestName() {
        if (this.requestMethod != null && this.requestName != null) {
            return String.valueOf((Object)this.requestMethod) + " " + this.requestName;
        }
        if (this.requestName != null) {
            return this.requestName;
        }
        return "";
    }

    public void setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void prepare() throws TransletNotFoundException, ActivityPrepareException {
        Assert.state(this.requestName != null, "requestName is not set");
        Assert.state(this.requestMethod != null, "requestMethod is not set");
        this.prepare(this.requestName, this.requestMethod);
    }

    @Override
    protected void adapt() throws AdapterException {
        this.setSessionAdapter(this.aspectran.newSessionAdapter());
        AspectranRequestAdapter requestAdapter = new AspectranRequestAdapter(this.getTranslet().getRequestMethod());
        if (this.parameterMap != null) {
            requestAdapter.setParameterMap(this.parameterMap);
        }
        if (this.attributeMap != null) {
            requestAdapter.setAttributeMap(this.attributeMap);
        }
        if (this.body != null) {
            requestAdapter.setBody(this.body);
        }
        this.setRequestAdapter(requestAdapter);
        if (this.outputWriter == null) {
            this.outputWriter = new OutputStringWriter();
        }
        AspectranResponseAdapter responseAdapter = new AspectranResponseAdapter(this.outputWriter);
        this.setResponseAdapter(responseAdapter);
        super.adapt();
    }

    @Override
    protected void saveCurrentActivity() {
        SessionAdapter sessionAdapter;
        super.saveCurrentActivity();
        if (!this.hasParentActivity() && (sessionAdapter = this.getSessionAdapter()) instanceof DefaultSessionAdapter) {
            DefaultSessionAdapter sessionAdapter2 = (DefaultSessionAdapter)sessionAdapter;
            sessionAdapter2.getSessionAgent().access();
        }
    }

    @Override
    protected void removeCurrentActivity() {
        SessionAdapter sessionAdapter;
        if (!this.hasParentActivity() && (sessionAdapter = this.getSessionAdapter()) instanceof DefaultSessionAdapter) {
            DefaultSessionAdapter sessionAdapter2 = (DefaultSessionAdapter)sessionAdapter;
            sessionAdapter2.getSessionAgent().complete();
        }
        super.removeCurrentActivity();
    }
}

