/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.embed.service;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.CoreTranslet;
import com.aspectran.core.activity.InstantAction;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.InstantActivityException;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.CoreServiceException;
import com.aspectran.core.service.CoreServiceHolder;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.embed.activity.AspectranActivity;
import com.aspectran.embed.service.AbstractEmbeddedAspectran;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Map;

public class DefaultEmbeddedAspectran
extends AbstractEmbeddedAspectran {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEmbeddedAspectran.class);
    private volatile long pauseTimeout = -1L;

    DefaultEmbeddedAspectran() {
    }

    @Override
    public <V> V execute(InstantAction<V> instantAction) {
        if (this.checkPaused()) {
            return null;
        }
        try {
            InstantActivity activity = new InstantActivity(this.getActivityContext());
            return activity.perform(instantAction);
        }
        catch (Exception e) {
            throw new InstantActivityException(e);
        }
    }

    @Override
    public Translet translate(String name) {
        return this.translate(name, null, null, null, null);
    }

    @Override
    public Translet translate(String name, String body) {
        return this.translate(name, null, null, null, body);
    }

    @Override
    public Translet translate(String name, Map<String, Object> attributeMap) {
        return this.translate(name, null, attributeMap, null, null);
    }

    @Override
    public Translet translate(String name, ParameterMap parameterMap) {
        return this.translate(name, null, null, parameterMap, null);
    }

    @Override
    public Translet translate(String name, Map<String, Object> attributeMap, ParameterMap parameterMap) {
        return this.translate(name, null, attributeMap, parameterMap, null);
    }

    @Override
    public Translet translate(String name, MethodType method) {
        return this.translate(name, method, null, null, null);
    }

    @Override
    public Translet translate(String name, MethodType method, Map<String, Object> attributeMap) {
        return this.translate(name, method, attributeMap, null, null);
    }

    @Override
    public Translet translate(String name, MethodType method, ParameterMap parameterMap) {
        return this.translate(name, method, null, parameterMap, null);
    }

    @Override
    public Translet translate(String name, MethodType method, Map<String, Object> attributeMap, ParameterMap parameterMap) {
        return this.translate(name, method, attributeMap, parameterMap, null);
    }

    @Override
    public Translet translate(String name, @Nullable MethodType method, @Nullable Map<String, Object> attributeMap, @Nullable ParameterMap parameterMap, @Nullable String body) {
        if (this.checkPaused()) {
            return null;
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (!this.isAcceptable(name)) {
            logger.error("Unavailable translet: " + name);
            return null;
        }
        AspectranActivity activity = new AspectranActivity(this);
        activity.setRequestName(name);
        activity.setRequestMethod(method != null ? method : MethodType.GET);
        activity.setAttributeMap(attributeMap);
        activity.setParameterMap(parameterMap);
        activity.setBody(body);
        CoreTranslet translet = null;
        try {
            activity.prepare();
            activity.perform();
            translet = activity.getTranslet();
        }
        catch (ActivityTerminatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (Exception e) {
            Throwable t = activity.getRaisedException() != null ? activity.getRaisedException() : e;
            Throwable cause = ExceptionUtils.getRootCause(t);
            throw new CoreServiceException("Error occurred while processing request: " + activity.getFullRequestName() + "; Cause: " + ExceptionUtils.getSimpleMessage(cause), t);
        }
        return translet;
    }

    @Override
    public String render(String templateId) {
        return this.render(templateId, null, null);
    }

    @Override
    public String render(String templateId, Map<String, Object> attributeMap) {
        return this.render(templateId, attributeMap, null);
    }

    @Override
    public String render(String templateId, ParameterMap parameterMap) {
        return this.render(templateId, null, parameterMap);
    }

    @Override
    public String render(String templateId, Map<String, Object> attributeMap, ParameterMap parameterMap) {
        if (this.checkPaused()) {
            return null;
        }
        try {
            InstantActivity activity = new InstantActivity(this.getActivityContext());
            activity.setSessionAdapter(this.newSessionAdapter());
            activity.setAttributeMap(attributeMap);
            activity.setParameterMap(parameterMap);
            return activity.perform(() -> {
                activity.getTemplateRenderer().render(templateId, (Activity)activity);
                return activity.getResponseAdapter().getWriter().toString();
            });
        }
        catch (Exception e) {
            throw new CoreServiceException("Error while rendering template: " + templateId, e);
        }
    }

    @NonNull
    static DefaultEmbeddedAspectran create(AspectranConfig aspectranConfig) {
        DefaultEmbeddedAspectran aspectran = new DefaultEmbeddedAspectran();
        aspectran.configure(aspectranConfig);
        DefaultEmbeddedAspectran.setServiceStateListener(aspectran);
        return aspectran;
    }

    private static void setServiceStateListener(final @NonNull DefaultEmbeddedAspectran aspectran) {
        aspectran.setServiceStateListener(new ServiceStateListener(){

            @Override
            public void started() {
                CoreServiceHolder.hold(aspectran);
                aspectran.createSessionManager();
                aspectran.pauseTimeout = 0L;
            }

            @Override
            public void stopped() {
                aspectran.destroySessionManager();
                CoreServiceHolder.release(aspectran);
            }

            @Override
            public void paused(long millis) {
                if (millis > 0L) {
                    aspectran.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            @Override
            public void paused() {
                aspectran.pauseTimeout = -1L;
            }

            @Override
            public void resumed() {
                aspectran.pauseTimeout = 0L;
            }
        });
    }

    private boolean checkPaused() {
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getServiceName() + " is paused");
                }
                return true;
            }
            this.pauseTimeout = 0L;
        }
        return false;
    }
}

