/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker;

import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.freemarker.directive.CustomTrimDirective;
import com.aspectran.freemarker.directive.TrimDirective;
import com.aspectran.freemarker.directive.TrimDirectiveGroup;
import com.aspectran.freemarker.directive.Trimmer;
import com.aspectran.utils.PropertiesLoaderUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModelEx;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigurationFactory
implements ActivityContextAware {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static final String DIRECTIVE_NAME_PARAM_NAME = "name";
    private ActivityContext context;
    private String configLocation;
    private Properties freemarkerSettings;
    private Map<String, Object> freemarkerVariables;
    private String defaultEncoding;
    private String[] templateLoaderPaths;
    private TemplateLoader[] templateLoaders;
    private TrimDirective[] trimDirectives;

    @Override
    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.context = context;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setFreemarkerSettings(Properties settings) {
        this.freemarkerSettings = settings;
    }

    public void setFreemarkerVariables(Map<String, Object> variables) {
        this.freemarkerVariables = variables;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setTemplateLoaderPath(String templateLoaderPath) {
        this.templateLoaderPaths = new String[]{templateLoaderPath};
    }

    public void setTemplateLoaderPath(String ... templateLoaderPaths) {
        this.templateLoaderPaths = templateLoaderPaths;
    }

    public void setTemplateLoaderPath(@NonNull List<String> templateLoaderPathList) {
        this.templateLoaderPaths = templateLoaderPathList.toArray(new String[0]);
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoaders = new TemplateLoader[]{templateLoader};
    }

    public void setTemplateLoader(TemplateLoader ... templateLoaders) {
        this.templateLoaders = templateLoaders;
    }

    public void setTemplateLoader(@NonNull List<TemplateLoader> templateLoaderList) {
        this.templateLoaders = templateLoaderList.toArray(new TemplateLoader[0]);
    }

    public void setTrimDirectives(TrimDirective ... trimDirectives) {
        this.trimDirectives = trimDirectives;
    }

    public void setTrimDirectives(@NonNull Parameters parameters) {
        String[] directiveGroupNames = parameters.getParameterNames();
        ArrayList<CustomTrimDirective> list = new ArrayList<CustomTrimDirective>();
        for (String groupName : directiveGroupNames) {
            List paramsList = parameters.getParametersList(groupName);
            for (Parameters p : paramsList) {
                Trimmer trimmer;
                if (p == null) continue;
                String directiveName = p.getString(DIRECTIVE_NAME_PARAM_NAME);
                String prefix = p.getString("prefix");
                String suffix = p.getString("suffix");
                String[] deprefixes = p.getStringArray("deprefixes");
                String[] desuffixes = p.getStringArray("desuffixes");
                boolean caseSensitive = Boolean.parseBoolean(p.getString("caseSensitive"));
                if (directiveName == null) continue;
                if (prefix != null || suffix != null || deprefixes != null || desuffixes != null) {
                    trimmer = new Trimmer();
                    trimmer.setPrefix(prefix);
                    trimmer.setSuffix(suffix);
                    trimmer.setDeprefixes(deprefixes);
                    trimmer.setDesuffixes(desuffixes);
                    trimmer.setCaseSensitive(caseSensitive);
                } else {
                    trimmer = null;
                }
                CustomTrimDirective ctd = new CustomTrimDirective(groupName, directiveName, trimmer);
                list.add(ctd);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("CustomTrimDirective " + String.valueOf(ctd));
            }
        }
        this.trimDirectives = !list.isEmpty() ? list.toArray(new TrimDirective[0]) : null;
    }

    public Configuration createConfiguration() throws IOException, TemplateException {
        TemplateLoader templateLoader;
        Configuration config = this.newConfiguration();
        Properties props = new Properties();
        if (this.configLocation != null) {
            logger.info("Loading Freemarker settings from [" + this.configLocation + "]");
            props.putAll((Map<?, ?>)PropertiesLoaderUtils.loadProperties(this.configLocation));
        }
        if (this.freemarkerSettings != null) {
            props.putAll((Map<?, ?>)this.freemarkerSettings);
        }
        if (!props.isEmpty()) {
            config.setSettings(props);
        }
        if (this.freemarkerVariables != null && !this.freemarkerVariables.isEmpty()) {
            config.setAllSharedVariables((TemplateHashModelEx)new SimpleHash(this.freemarkerVariables, config.getObjectWrapper()));
        }
        if (this.defaultEncoding != null) {
            config.setDefaultEncoding(this.defaultEncoding);
        }
        if (this.templateLoaders == null && this.templateLoaderPaths != null && this.templateLoaderPaths.length > 0) {
            ArrayList<TemplateLoader> templateLoaderList = new ArrayList<TemplateLoader>();
            for (String path : this.templateLoaderPaths) {
                templateLoaderList.add(this.getTemplateLoaderForPath(path));
            }
            this.setTemplateLoader(templateLoaderList);
        }
        if ((templateLoader = this.getAggregateTemplateLoader(this.templateLoaders)) != null) {
            config.setTemplateLoader(templateLoader);
        }
        if (this.trimDirectives != null && this.trimDirectives.length > 0) {
            TrimDirectiveGroup group = new TrimDirectiveGroup(this.trimDirectives);
            for (Map.Entry directives : group.entrySet()) {
                config.setSharedVariable((String)directives.getKey(), directives.getValue());
            }
        }
        return config;
    }

    protected Configuration newConfiguration() {
        return new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    }

    protected TemplateLoader getAggregateTemplateLoader(TemplateLoader[] templateLoaders) {
        int loaderCount = templateLoaders != null ? templateLoaders.length : 0;
        switch (loaderCount) {
            case 0: {
                if (logger.isDebugEnabled()) {
                    logger.debug("No FreeMarker TemplateLoaders specified; Can be used only inner template source");
                }
                return null;
            }
            case 1: {
                if (logger.isDebugEnabled()) {
                    logger.debug("One FreeMarker TemplateLoader registered: " + String.valueOf(templateLoaders[0]));
                }
                return templateLoaders[0];
            }
        }
        MultiTemplateLoader loader = new MultiTemplateLoader(templateLoaders);
        if (logger.isDebugEnabled()) {
            logger.debug("Multiple FreeMarker TemplateLoader registered: " + String.valueOf(loader));
        }
        return loader;
    }

    protected TemplateLoader getTemplateLoaderForPath(@NonNull String templateLoaderPath) throws IOException {
        if (templateLoaderPath.startsWith("classpath:")) {
            String basePackagePath = templateLoaderPath.substring("classpath:".length());
            if (logger.isDebugEnabled()) {
                logger.debug("Template loader path [" + templateLoaderPath + "] resolved to class path [" + basePackagePath + "]");
            }
            return new ClassTemplateLoader(this.context.getAvailableActivity().getClassLoader(), basePackagePath);
        }
        if (templateLoaderPath.startsWith("file:")) {
            File file = new File(templateLoaderPath.substring("file:".length()));
            if (logger.isDebugEnabled()) {
                logger.debug("Template loader path [" + templateLoaderPath + "] resolved to file path [" + file.getAbsolutePath() + "]");
            }
            return new FileTemplateLoader(file);
        }
        File file = new File(this.context.getApplicationAdapter().getBasePath(), templateLoaderPath);
        if (logger.isDebugEnabled()) {
            logger.debug("Template loader path [" + templateLoaderPath + "] resolved to file path [" + file.getAbsolutePath() + "]");
        }
        return new FileTemplateLoader(file);
    }
}

