/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityData;
import com.aspectran.core.component.template.engine.TemplateEngine;
import com.aspectran.core.component.template.engine.TemplateEngineProcessException;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Locale;

public class FreeMarkerTemplateEngine
implements TemplateEngine {
    private final Configuration configuration;

    public FreeMarkerTemplateEngine(Configuration configuration) {
        Assert.notNull((Object)configuration, "configuration must not be null");
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void process(String templateName, Activity activity) throws TemplateEngineProcessException {
        this.checkHasConfiguration();
        try {
            FreeMarkerTemplateEngine.process(this.configuration, templateName, activity);
            activity.getResponseAdapter().getWriter().flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException(e);
        }
    }

    @Override
    public void process(String templateSource, String contentType, Activity activity) throws TemplateEngineProcessException {
        this.checkHasConfiguration();
        try {
            ActivityData variables = activity.getActivityData();
            Writer writer = activity.getResponseAdapter().getWriter();
            String templateName = this.createTemplateName(templateSource);
            StringReader reader = new StringReader(templateSource);
            Template template = new Template(templateName, (Reader)reader, this.configuration);
            template.process((Object)variables, writer);
            writer.flush();
        }
        catch (Exception e) {
            throw new TemplateEngineProcessException(e);
        }
    }

    public static void process(Configuration configuration, String templateName, Activity activity) throws IOException, TemplateException {
        Assert.notNull((Object)configuration, "configuration must not be null");
        Assert.notNull((Object)templateName, "templateName must not be null");
        Assert.notNull((Object)activity, "activity must not be null");
        Locale locale = activity.getRequestAdapter().getLocale();
        ActivityData variables = activity.getActivityData();
        Writer writer = activity.getResponseAdapter().getWriter();
        Template template = configuration.getTemplate(templateName, locale);
        template.process((Object)variables, writer);
    }

    private void checkHasConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException("Configuration not specified");
        }
    }

    @NonNull
    private String createTemplateName(@NonNull String templateSource) {
        int hashCode = templateSource.hashCode();
        if (hashCode >= 0) {
            return Long.toString(hashCode, 32);
        }
        return Long.toString(hashCode & Integer.MAX_VALUE, 32);
    }
}

