/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.freemarker.view;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.dispatch.AbstractViewDispatcher;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.freemarker.FreeMarkerTemplateEngine;
import com.aspectran.utils.Assert;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import freemarker.template.Configuration;

public class FreeMarkerViewDispatcher
extends AbstractViewDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(FreeMarkerViewDispatcher.class);
    private final Configuration configuration;

    public FreeMarkerViewDispatcher(FreeMarkerTemplateEngine templateEngine) {
        Assert.notNull((Object)templateEngine, "templateEngine must not be null");
        this.configuration = templateEngine.getConfiguration();
    }

    public FreeMarkerViewDispatcher(Configuration configuration) {
        Assert.notNull((Object)configuration, "configuration must not be null");
        this.configuration = configuration;
    }

    @Override
    public void dispatch(Activity activity, DispatchRule dispatchRule) throws ViewDispatcherException {
        String viewName = null;
        try {
            String encoding;
            viewName = this.resolveViewName(dispatchRule, activity);
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            String contentType = dispatchRule.getContentType();
            if (contentType == null) {
                contentType = this.getContentType();
            }
            if (contentType != null) {
                responseAdapter.setContentType(contentType);
            }
            if ((encoding = dispatchRule.getEncoding()) == null && responseAdapter.getEncoding() == null) {
                encoding = activity.getTranslet().getDefinitiveResponseEncoding();
            }
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Dispatching to FreeMarker template [" + viewName + "]");
            }
            FreeMarkerTemplateEngine.process(this.configuration, viewName, activity);
        }
        catch (Exception e) {
            activity.setRaisedException(e);
            throw new ViewDispatcherException("Failed to dispatch to FreeMarker template " + dispatchRule.toString(this, viewName), e);
        }
    }
}

