/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.daemon.command;

import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.component.bean.BeanException;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.context.asel.item.ItemEvaluator;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.jetty.server.JettyServer;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.net.BindException;

public class JettyCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "jetty";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public JettyCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        try {
            String mode = null;
            String serverName = null;
            ItemRuleMap parameterItemRuleMap = parameters.getParameterItemRuleMap();
            if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
                ItemEvaluator evaluator = this.getDaemonService().getDefaultActivity().getItemEvaluator();
                ParameterMap parameterMap = evaluator.evaluateAsParameterMap(parameterItemRuleMap);
                mode = parameterMap.getParameter("mode");
                serverName = parameterMap.getParameter("server");
            }
            if (mode == null) {
                return this.failed("'mode' parameter is not specified");
            }
            if (!StringUtils.hasLength(serverName)) {
                serverName = "jetty.server";
            }
            switch (mode) {
                case "start": {
                    return this.startJettyServer(serverName);
                }
                case "stop": {
                    return this.stopJettyServer(serverName);
                }
                case "restart": {
                    CommandResult commandResult = this.stopJettyServer(serverName);
                    if (commandResult.isSuccess()) {
                        commandResult = this.startJettyServer(serverName);
                    }
                    return commandResult;
                }
                case "status": {
                    return this.printServerStatus(serverName);
                }
            }
            return this.failed(this.error("Unknown mode '" + mode + "'"));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    private CommandResult startJettyServer(String serverName) throws Exception {
        JettyServer jettyServer = null;
        try {
            if (this.hasJettyServer(serverName)) {
                jettyServer = this.getJettyServer(serverName);
                if (jettyServer.isRunning()) {
                    return this.failed(this.warn("Jetty server is already running"));
                }
                jettyServer.start();
                return this.success(this.info(this.getStatus(jettyServer.getState())));
            }
            jettyServer = this.getJettyServer(serverName);
            if (!jettyServer.isRunning()) {
                jettyServer.start();
            }
            return this.success(this.info(this.getStatus(jettyServer.getState())));
        }
        catch (Exception e) {
            Throwable cause;
            if (jettyServer != null) {
                this.destroyJettyServer(jettyServer);
            }
            if ((cause = ExceptionUtils.getRootCause(e)) instanceof BindException) {
                return this.failed("Jetty server failed to start. Cause: Port already in use", e);
            }
            return this.failed(e);
        }
    }

    private CommandResult stopJettyServer(String serverName) {
        try {
            if (this.hasJettyServer(serverName)) {
                JettyServer jettyServer = this.getJettyServer(serverName);
                this.destroyJettyServer(jettyServer);
                return this.success(this.info(this.getStatus("STOPPED")));
            }
            return this.failed(this.warn("Jetty server is not running"));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    private CommandResult printServerStatus(String serverName) {
        try {
            if (this.hasJettyServer(serverName)) {
                JettyServer jettyServer = this.getJettyServer(serverName);
                if (jettyServer.isStarted()) {
                    return this.success(this.info(this.getStatus("RUNNING")));
                }
                return this.success(this.info(this.getStatus(jettyServer.getState())));
            }
            return this.success(this.info(this.getStatus("STOPPED")));
        }
        catch (BeanException e) {
            return this.failed("Jetty server is not available", e);
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @NonNull
    private String getStatus(String status) {
        return status + " - Jetty " + JettyServer.getVersion();
    }

    private JettyServer getJettyServer(String serverName) {
        BeanRegistry beanRegistry = this.getDaemonService().getActivityContext().getBeanRegistry();
        return beanRegistry.getBean(JettyServer.class, serverName);
    }

    private boolean hasJettyServer(String serverName) {
        BeanRegistry beanRegistry = this.getDaemonService().getActivityContext().getBeanRegistry();
        return beanRegistry.hasSingleton(JettyServer.class, serverName);
    }

    private void destroyJettyServer(JettyServer jettyServer) throws Exception {
        BeanRegistry beanRegistry = this.getDaemonService().getActivityContext().getBeanRegistry();
        beanRegistry.destroySingleton(jettyServer);
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return JettyCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return JettyCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Use the command 'jetty' to control the Jetty server";
        }
    }
}

