/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.server;

import com.aspectran.jetty.server.GracefulShutdownCallback;
import com.aspectran.jetty.server.GracefulShutdownResult;
import com.aspectran.jetty.server.JettyServer;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.handler.StatisticsHandler;

final class GracefulShutdown {
    private static final Logger logger = LoggerFactory.getLogger(GracefulShutdown.class);
    private final JettyServer server;
    private volatile boolean shuttingDown = false;

    GracefulShutdown(JettyServer server) {
        this.server = server;
    }

    void shutDownGracefully(@NonNull GracefulShutdownCallback callback) {
        logger.info("Commencing graceful shutdown. Waiting for active requests to complete");
        for (Connector connector : this.server.getConnectors()) {
            this.shutdown(connector);
        }
        this.shuttingDown = true;
        new Thread(() -> this.awaitShutdown(callback), "shutdown").start();
    }

    private void shutdown(@NonNull Connector connector) {
        Future result;
        try {
            result = connector.shutdown();
        }
        catch (NoSuchMethodError ex) {
            try {
                result = (Future)MethodUtils.invokeExactMethod(connector, "shutdown");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Could not access method: shutdown", ExceptionUtils.getRootCause(e));
            }
        }
        try {
            result.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    private void awaitShutdown(GracefulShutdownCallback callback) {
        int activeRequests = 0;
        while (this.shuttingDown && (activeRequests = this.getActiveRequests()) > 0) {
            this.sleep(100L);
        }
        this.shuttingDown = false;
        if (activeRequests == 0) {
            logger.info("Graceful shutdown complete");
            callback.shutdownComplete(GracefulShutdownResult.IDLE);
        } else {
            logger.info("Graceful shutdown aborted with " + activeRequests + " request" + (activeRequests == 1 ? "" : "s") + " still active");
            callback.shutdownComplete(GracefulShutdownResult.REQUESTS_ACTIVE);
        }
    }

    private int getActiveRequests() {
        StatisticsHandler statisticsHandler = this.server.getStatisticsHandler();
        return statisticsHandler != null ? statisticsHandler.getRequestsActive() : 0;
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    void abort() {
        this.shuttingDown = false;
    }
}

