/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.server;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.jetty.server.GracefulShutdown;
import com.aspectran.jetty.server.servlet.JettyWebAppContext;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.server.ConnectionLimit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer
extends Server
implements InitializableBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(JettyServer.class);
    private boolean shutdownGracefully;
    private GracefulShutdown gracefulShutdown;
    private boolean autoStart;

    public JettyServer() {
    }

    public JettyServer(int port) {
        super(port);
    }

    public JettyServer(ThreadPool pool) {
        super(pool);
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setShutdownGracefully(boolean shutdownGracefully) {
        this.shutdownGracefully = shutdownGracefully;
    }

    public void setMaxConnections(int maxConnections) {
        if (maxConnections > -1) {
            this.addBean(new ConnectionLimit(maxConnections, (Server)this));
        }
    }

    public void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    public StatisticsHandler getStatisticsHandler() {
        return this.findStatisticsHandler(this.getHandler());
    }

    private StatisticsHandler findStatisticsHandler(Handler handler) {
        if (handler instanceof StatisticsHandler) {
            StatisticsHandler statisticsHandler = (StatisticsHandler)handler;
            return statisticsHandler;
        }
        if (handler instanceof Handler.Wrapper) {
            Handler.Wrapper handlerWrapper = (Handler.Wrapper)handler;
            return this.findStatisticsHandler(handlerWrapper.getHandler());
        }
        return null;
    }

    public ContextHandler getContextHandler(String contextPath) {
        return this.findContextHandler(contextPath, this.getHandler());
    }

    private ContextHandler findContextHandler(String contextPath, Handler handler) {
        Handler.Sequence handlerSequence;
        Iterator iterator;
        ContextHandler contextHandler;
        if (handler instanceof ContextHandler && Objects.equals(contextPath, (contextHandler = (ContextHandler)handler).getContextPath())) {
            return contextHandler;
        }
        if (handler instanceof Handler.Wrapper) {
            Handler.Wrapper handlerWrapper = (Handler.Wrapper)handler;
            return this.findContextHandler(contextPath, handlerWrapper.getHandler());
        }
        if (handler instanceof Handler.Sequence && (iterator = (handlerSequence = (Handler.Sequence)handler).getHandlers().iterator()).hasNext()) {
            Handler child = (Handler)iterator.next();
            return this.findContextHandler(contextPath, child);
        }
        return null;
    }

    public SessionHandler getSessionHandler(String contextPath) {
        ContextHandler contextHandler = this.getContextHandler(contextPath);
        if (contextHandler instanceof WebAppContext) {
            WebAppContext webAppContext = (WebAppContext)contextHandler;
            return webAppContext.getSessionHandler();
        }
        return null;
    }

    @Override
    public void initialize() throws Exception {
        this.setStopAtShutdown(false);
        if (this.autoStart) {
            this.start();
        }
    }

    @Override
    public void destroy() {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error("Error while stopping jetty server", e);
        }
    }

    public void doStart() throws Exception {
        logger.info("Starting embedded Jetty server");
        if (this.shutdownGracefully && this.getStatisticsHandler() != null) {
            this.gracefulShutdown = new GracefulShutdown(this);
        } else if (this.gracefulShutdown != null) {
            this.gracefulShutdown.abort();
            this.gracefulShutdown = null;
        }
        for (Handler handler : this.getHandlers()) {
            this.handleDeferredInitialize(handler);
        }
        super.doStart();
        logger.info("Jetty started on port(s) " + this.getActualPortsDescription() + " with context path '" + this.getContextPath() + "'");
    }

    public void doStop() {
        logger.info("Stopping embedded Jetty server");
        if (this.gracefulShutdown != null) {
            this.gracefulShutdown.shutDownGracefully(result -> {
                try {
                    super.doStop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    logger.error("Unable to stop embedded Jetty server", e);
                }
            });
        } else {
            try {
                super.doStop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                logger.error("Unable to stop embedded Jetty server", e);
            }
        }
    }

    private void handleDeferredInitialize(Handler handler) {
        if (handler instanceof JettyWebAppContext) {
            JettyWebAppContext jettyWebAppContext = (JettyWebAppContext)handler;
            jettyWebAppContext.deferredInitialize(this);
        } else if (handler instanceof Handler.Wrapper) {
            Handler.Wrapper handlerWrapper = (Handler.Wrapper)handler;
            this.handleDeferredInitialize(handlerWrapper.getHandler());
        } else if (handler instanceof Handler.Collection) {
            Handler.Collection handlerCollection = (Handler.Collection)handler;
            this.handleDeferredInitialize(handlerCollection.getHandlers());
        }
    }

    private void handleDeferredInitialize(@NonNull List<Handler> handlers) {
        for (Handler handler : handlers) {
            this.handleDeferredInitialize(handler);
        }
    }

    private String getContextPath() {
        Handler.Container handlerContainer = (Handler.Container)this.getHandler();
        return handlerContainer.getHandlers().stream().filter(ContextHandler.class::isInstance).map(ContextHandler.class::cast).map(ContextHandler::getContextPath).collect(Collectors.joining("', '"));
    }

    @NonNull
    private String getActualPortsDescription() {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.getConnectors()) {
            NetworkConnector connector1 = (NetworkConnector)connector;
            if (!ports.isEmpty()) {
                ports.append(", ");
            }
            ports.append(connector1.getLocalPort());
            ports.append(" (");
            ports.append(StringUtils.joinCommaDelimitedList(connector.getProtocols()));
            ports.append(")");
        }
        return ports.toString();
    }
}

