/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.server.servlet;

import com.aspectran.jetty.server.servlet.JettyFilterMapping;
import com.aspectran.jetty.server.servlet.JettyFilterServletMapping;
import com.aspectran.jetty.server.servlet.JettyFilterUrlMapping;
import com.aspectran.utils.ClassUtils;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.jetty.ee10.servlet.FilterHolder;

public class JettyFilter
extends FilterHolder {
    private JettyFilterUrlMapping[] urlMappings;
    private JettyFilterServletMapping[] servletMappings;

    public JettyFilter(String name, String filterClass) throws ClassNotFoundException {
        this(name, ClassUtils.loadClass(filterClass));
    }

    public JettyFilter(String name, Class<? extends Filter> filterClass) {
        this.setName(name);
        this.setHeldClass(filterClass);
    }

    public JettyFilterUrlMapping[] getUrlMappings() {
        return this.urlMappings;
    }

    public void setMappingUrls(String[] mappingUrls) {
        if (mappingUrls != null) {
            ArrayList<JettyFilterMapping> mappingList = new ArrayList<JettyFilterMapping>(mappingUrls.length);
            for (String url : mappingUrls) {
                mappingList.add(new JettyFilterMapping(url));
            }
            this.setUrlMappings(mappingList.toArray(new JettyFilterMapping[0]));
        }
    }

    public void setUrlMappings(JettyFilterMapping[] jettyFilterMappings) {
        if (jettyFilterMappings != null) {
            ArrayList<JettyFilterUrlMapping> urlMappingList;
            if (this.urlMappings != null) {
                urlMappingList = new ArrayList(this.servletMappings.length + jettyFilterMappings.length);
                urlMappingList.addAll(Arrays.asList(this.urlMappings));
            } else {
                urlMappingList = new ArrayList<JettyFilterUrlMapping>(jettyFilterMappings.length);
            }
            for (JettyFilterMapping mapping : jettyFilterMappings) {
                urlMappingList.addAll(JettyFilterUrlMapping.of(this.getName(), mapping));
            }
            this.urlMappings = urlMappingList.toArray(new JettyFilterUrlMapping[0]);
        }
    }

    public JettyFilterServletMapping[] getServletMappings() {
        return this.servletMappings;
    }

    public void setMappingServlets(String[] mappingServlets) {
        if (mappingServlets != null) {
            ArrayList<JettyFilterMapping> mappingList = new ArrayList<JettyFilterMapping>(mappingServlets.length);
            for (String servletName : mappingServlets) {
                mappingList.add(new JettyFilterMapping(servletName));
            }
            this.setServletMappings(mappingList.toArray(new JettyFilterMapping[0]));
        }
    }

    public void setServletMappings(JettyFilterMapping[] jettyFilterMappings) {
        if (jettyFilterMappings != null) {
            ArrayList<JettyFilterServletMapping> servletMappingList;
            if (this.servletMappings != null) {
                servletMappingList = new ArrayList(this.servletMappings.length + jettyFilterMappings.length);
                servletMappingList.addAll(Arrays.asList(this.servletMappings));
            } else {
                servletMappingList = new ArrayList<JettyFilterServletMapping>(jettyFilterMappings.length);
            }
            for (JettyFilterMapping jettyFilterMapping : jettyFilterMappings) {
                servletMappingList.addAll(JettyFilterServletMapping.of(this.getName(), jettyFilterMapping));
            }
            this.servletMappings = servletMappingList.toArray(new JettyFilterServletMapping[0]);
        }
    }

    public void setInitParams(Map<String, String> initParams) {
        if (initParams != null) {
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                this.setInitParameter(entry.getKey(), entry.getValue());
            }
        }
    }
}

