/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.server.servlet;

import com.aspectran.jetty.server.servlet.JettyFilterMapping;
import com.aspectran.utils.annotation.jsr305.NonNull;
import jakarta.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.FilterMapping;

public class JettyFilterServletMapping
extends FilterMapping {
    JettyFilterServletMapping(String filterName, String mapping) {
        this(filterName, mapping, DispatcherType.REQUEST);
    }

    JettyFilterServletMapping(String filterName, String mapping, DispatcherType ... dispatchers) {
        this.setFilterName(filterName);
        this.setServletName(mapping);
        if (dispatchers != null && dispatchers.length > 0) {
            this.setDispatcherTypes(EnumSet.of(dispatchers[0], dispatchers));
        }
    }

    @NonNull
    static List<JettyFilterServletMapping> of(String filterName, @NonNull JettyFilterMapping jettyFilterMapping) {
        DispatcherType[] dispatchers = jettyFilterMapping.getDispatchers();
        ArrayList<JettyFilterServletMapping> list = new ArrayList<JettyFilterServletMapping>(dispatchers.length);
        for (DispatcherType dispatcherType : dispatchers) {
            list.add(new JettyFilterServletMapping(filterName, jettyFilterMapping.getTarget(), dispatcherType));
        }
        return list;
    }
}

