/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.jetty.server.servlet;

import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreService;
import com.aspectran.jetty.server.servlet.JettyErrorPage;
import com.aspectran.jetty.server.servlet.JettyFilter;
import com.aspectran.jetty.server.servlet.JettyListener;
import com.aspectran.jetty.server.servlet.JettyServlet;
import com.aspectran.jetty.server.servlet.JettyWebSocketInitializer;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.DefaultWebServiceBuilder;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.websocket.server.ServerContainer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.ee10.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.FilterMapping;
import org.eclipse.jetty.ee10.servlet.ListenerHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.ServletMapping;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.ee10.websocket.jakarta.server.JakartaWebSocketServerContainer;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;

public class JettyWebAppContext
extends WebAppContext
implements ActivityContextAware {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebAppContext.class);
    private ActivityContext context;
    private List<JettyErrorPage> errorPages;
    private JettyWebSocketInitializer webSocketInitializer;

    @NonNull
    private ActivityContext getActivityContext() {
        Assert.state(this.context != null, "No ActivityContext injected");
        return this.context;
    }

    @Override
    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.context = context;
    }

    public void setWar(String war) {
        File warFile = null;
        try {
            warFile = new File(war);
            if (warFile.isDirectory()) {
                if (!warFile.exists() && !warFile.mkdirs()) {
                    throw new IOException("Unable to create war directory: " + String.valueOf(warFile));
                }
                this.setExtractWAR(true);
            }
            super.setWar(warFile.getCanonicalPath());
        }
        catch (Exception e) {
            logger.error("Failed to establish Scratch directory: " + String.valueOf(warFile), e);
        }
    }

    public void setTempDirectory(String tempDirectory) {
        File tempDir = null;
        try {
            tempDir = new File(tempDirectory);
            if (!tempDir.exists() && !tempDir.mkdirs()) {
                throw new IOException("Unable to create scratch directory: " + String.valueOf(tempDir));
            }
            super.setTempDirectory(tempDir.getCanonicalFile());
        }
        catch (Exception e) {
            logger.error("Failed to establish Scratch directory: " + String.valueOf(tempDir), e);
        }
    }

    public void setDefaultsDescriptor(String defaultsDescriptor) {
        if (StringUtils.hasLength(defaultsDescriptor)) {
            Resource dftResource;
            try {
                dftResource = this.getResourceFactory().newClassLoaderResource(defaultsDescriptor);
                if (Resources.missing((Resource)dftResource)) {
                    URL url;
                    String pkg = WebXmlConfiguration.class.getPackageName().replace(".", "/") + "/";
                    if (defaultsDescriptor.startsWith(pkg) && (url = WebXmlConfiguration.class.getResource(defaultsDescriptor.substring(pkg.length()))) != null) {
                        URI uri = url.toURI();
                        dftResource = this.getResourceFactory().newResource(uri);
                    }
                    if (Resources.missing((Resource)dftResource)) {
                        dftResource = this.newResource(defaultsDescriptor);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid default descriptor: " + defaultsDescriptor, e);
            }
            if (Resources.isReadableFile((Resource)dftResource)) {
                super.setDefaultsDescriptor(defaultsDescriptor);
            } else {
                throw new IllegalArgumentException("Unable to locate default descriptor: " + defaultsDescriptor);
            }
        }
    }

    public void setInitParams(Map<String, String> initParams) {
        if (initParams != null) {
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                this.setInitParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setListeners(JettyListener[] jettyListeners) {
        if (jettyListeners != null) {
            for (JettyListener jettyListener : jettyListeners) {
                this.getServletHandler().addListener((ListenerHolder)jettyListener);
            }
        }
    }

    public void setWebListeners(EventListener[] eventListeners) {
        if (eventListeners != null) {
            for (EventListener eventListener : eventListeners) {
                this.addEventListener(eventListener);
            }
        }
    }

    public void setServlets(JettyServlet[] servlets) {
        if (servlets != null) {
            for (JettyServlet servlet : servlets) {
                this.getServletHandler().addServlet((ServletHolder)servlet);
                ServletMapping mapping = new ServletMapping();
                mapping.setServletName(servlet.getName());
                mapping.setPathSpecs(servlet.getMappings());
                this.getServletHandler().addServletMapping(mapping);
            }
        }
    }

    public void setFilters(JettyFilter[] jettyFilters) {
        if (jettyFilters != null) {
            for (JettyFilter jettyFilter : jettyFilters) {
                this.getServletHandler().addFilter((FilterHolder)jettyFilter);
                if (jettyFilter.getUrlMappings() != null) {
                    for (FilterMapping filterMapping : jettyFilter.getUrlMappings()) {
                        this.getServletHandler().addFilterMapping(filterMapping);
                    }
                }
                if (jettyFilter.getServletMappings() == null) continue;
                for (FilterMapping filterMapping : jettyFilter.getServletMappings()) {
                    this.getServletHandler().addFilterMapping(filterMapping);
                }
            }
        }
    }

    public void setErrorPages(JettyErrorPage[] errorPages) {
        this.errorPages = errorPages != null && errorPages.length > 0 ? Arrays.asList(errorPages) : null;
    }

    public void setServletContainerInitializers(ServletContainerInitializer[] servletContainerInitializers) {
        Assert.notNull((Object)servletContainerInitializers, "servletContainerInitializers must not be null");
        for (ServletContainerInitializer initializer : servletContainerInitializers) {
            this.addServletContainerInitializer(initializer);
        }
    }

    public void setWebSocketInitializer(JettyWebSocketInitializer webSocketInitializer) {
        this.webSocketInitializer = webSocketInitializer;
    }

    public void deferredInitialize(Server server) {
        WebAppClassLoader webAppClassLoader = new WebAppClassLoader(this.getActivityContext().getClassLoader(), (WebAppClassLoader.Context)this);
        this.setClassLoader((ClassLoader)webAppClassLoader);
        if (this.errorPages != null) {
            ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
            for (JettyErrorPage errorPage : this.errorPages) {
                if (!StringUtils.hasText(errorPage.getLocation())) continue;
                if (errorPage.getErrorCode() != null) {
                    if (errorPage.getToErrorCode() != null) {
                        errorHandler.addErrorPage(errorPage.getErrorCode().intValue(), errorPage.getToErrorCode().intValue(), errorPage.getLocation());
                        continue;
                    }
                    errorHandler.addErrorPage(errorPage.getErrorCode().intValue(), errorPage.getLocation());
                    continue;
                }
                if (errorPage.getExceptionType() == null) continue;
                errorHandler.addErrorPage(errorPage.getExceptionType(), errorPage.getLocation());
            }
            this.setErrorHandler((Request.Handler)errorHandler);
        }
        if (this.webSocketInitializer != null) {
            JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)this, (servletContext, jettyWebSocketServerContainer) -> {
                JakartaWebSocketServerContainer serverContainer = JakartaWebSocketServerContainer.ensureContainer((ServletContext)servletContext);
                this.webSocketInitializer.customize((ServerContainer)serverContainer);
            });
        }
        CoreService masterService = this.getActivityContext().getMasterService();
        final DefaultWebService rootWebService = DefaultWebServiceBuilder.build(this.getServletContext(), masterService);
        if (rootWebService.isOrphan()) {
            server.addEventListener((EventListener)new LifeCycle.Listener(){

                public void lifeCycleStarted(LifeCycle event) {
                    try {
                        rootWebService.getServiceLifeCycle().start();
                    }
                    catch (Exception e) {
                        logger.error("Failed to start root web service", e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }
}

